/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseIDs;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.unchecked.functiontypes.ConsumerE;
import org.apache.maven.plugin.logging.Log;

public class Decider {
    private final Log log;

    public Decider(Log log) {
        this.log = log;
    }

    public MappedLicense decide(MappedLicense byCoordinates, MappedLicense byName, MappedLicense byUrl) {
        if (byCoordinates.isPresent()) {
            return this.decideWithCoordinates(byCoordinates, byName, byUrl);
        }
        if (byName.isPresent()) {
            return this.decideWithName(byName, byUrl);
        }
        byUrl.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)this::warnOnAnd));
        if (byUrl.isPresent()) {
            this.log.debug((CharSequence)"      license by url ");
            return byUrl.addReason("no name or coordinates");
        }
        this.log.debug((CharSequence)"      no license ");
        return MappedLicense.empty();
    }

    private MappedLicense decideWithName(MappedLicense licenseID, MappedLicense byUrl) {
        byUrl.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by url differs " + name));
            }
        }));
        licenseID.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)this::warnOnAnd));
        this.log.debug((CharSequence)"      license by name ");
        return licenseID.addReason("priority name");
    }

    private MappedLicense decideWithCoordinates(MappedLicense licenseID, MappedLicense byName, MappedLicense byUrl) {
        byName.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by name differs " + name));
            }
        }));
        byUrl.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by url differs " + name));
            }
        }));
        this.log.debug((CharSequence)"      license on coordinates ");
        return licenseID.addReason("coordinates priority");
    }

    private void warnOnAnd(LicenseID licenseID) {
        if (LicenseIDs.isAnd(licenseID)) {
            this.log.error((CharSequence)("   fulfilling the constraints of 2 license is unlikely, was 'or' meant? or really " + licenseID));
            this.log.error((CharSequence)"   set it directly in plugin configuration");
        }
    }
}

