/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import de.pfabulist.unchecked.functiontypes.ConsumerE;
import de.pfabulist.unchecked.functiontypes.FunctionE;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public class Coordinates2License {
    private Map<Coordinates, LiCo> list = new HashMap<Coordinates, LiCo>();
    private boolean andIsOr = false;
    @Nullable
    private transient Findings log;

    public void add(Coordinates coo) {
        this.list.putIfAbsent(coo, new LiCo());
        ((LiCo)NonnullCheck._nn((Object)this.list.get(coo))).used = true;
    }

    public void updateScope(Coordinates coo, String scope) {
        if (!this.list.containsKey(coo)) {
            throw new IllegalStateException("no such " + coo);
        }
        LiCo liCo = (LiCo)NonnullCheck._nn((Object)this.list.get(coo));
        String oldScope = (String)NonnullCheck._nn((Object)liCo.scope);
        if (this.getScopeLevel(scope) < this.getScopeLevel(oldScope)) {
            liCo.scope = scope;
        }
    }

    int getScopeLevel(String scope) {
        switch (scope) {
            case "plugin": {
                return 8;
            }
            case "import": {
                return 7;
            }
            case "system": {
                return 6;
            }
            case "test": {
                return 5;
            }
            case "runtime": {
                return 4;
            }
            case "provided": {
                return 3;
            }
            case "optional": {
                return 2;
            }
            case "compile": {
                return 1;
            }
        }
        this.getLog().warn("unexpected scope " + scope);
        return 100;
    }

    private Findings getLog() {
        return (Findings)NullCheck._orElseThrow((Object)this.log, () -> new IllegalStateException("no logger"));
    }

    public void determineLicenses(FunctionE<Coordinates, MappedLicense, Exception> f) {
        this.list.forEach((c, coli) -> {
            if (coli.isUsed()) {
                this.getLog().debug("license for " + c + " is ...");
                if (!coli.getLicense().isPresent()) {
                    coli.setLicense((MappedLicense)NonnullCheck._nn((Object)f.apply(c)));
                    this.getLog().debug("license for " + c + " is (found) to be " + coli.getLicense());
                } else {
                    this.getLog().debug("license for " + c + " is known to be " + coli.getLicense().get());
                }
            }
        });
    }

    public Optional<LiCo> get(Coordinates coordinates) {
        return Optional.ofNullable(this.list.get(coordinates));
    }

    public void checkCompatibility(BiFunction<Coordinates, String, String> f) {
        this.list.forEach((c, coli) -> {
            if (coli.isUsed()) {
                coli.getLicense().ifPresent(l -> {
                    String message = (String)NonnullCheck._nn(f.apply((Coordinates)c, (String)l));
                    if (!message.isEmpty()) {
                        this.scopeDependingLog((Coordinates)c, message);
                    }
                    coli.setMessage(message);
                });
            }
        });
    }

    private void scopeDependingLog(Coordinates coo, String message) {
        String scope = ((LiCo)NullCheck._orElseThrow((Object)this.list.get(coo), () -> new IllegalStateException("huh"))).getScope();
        if (!scope.equals("plugin") && !scope.equals("test")) {
            this.getLog().error(message);
        } else {
            this.getLog().warn(message);
        }
    }

    public void summery() {
        this.list.entrySet().stream().filter(e -> ((LiCo)NonnullCheck._nn(e.getValue())).isUsed()).sorted((a, b) -> this.getScopeLevel(((LiCo)NonnullCheck._nn(a.getValue())).getScope()) - this.getScopeLevel(((LiCo)NonnullCheck._nn(b.getValue())).getScope())).forEach(e -> {
            Coordinates c = (Coordinates)NonnullCheck._nn(e.getKey());
            LiCo lico = (LiCo)NonnullCheck._nn(e.getValue());
            this.getLog().info(String.format("%-80s %-10s %-50s ", c, lico.getScope(), lico.getLicense().map(Object::toString).orElse("-")) + lico.getHolder().map(Object::toString).orElse("-"));
            if (!lico.getLicense().isPresent()) {
                this.getLog().error("   no license found");
            }
            if (!lico.getMessage().isEmpty()) {
                this.getLog().error("   " + lico.getMessage());
            }
            this.getLog().debug("    " + lico.getLicenseReason());
        });
    }

    public void getHolders(BiFunction<Coordinates, String, Optional<CopyrightHolder>> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed()) {
                lico.getLicense().ifPresent(l -> lico.setHolder((Optional)NonnullCheck._nn(f.apply((Coordinates)c, (String)l))));
            }
        });
    }

    public void fromSrc(BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed()) {
                f.accept((Coordinates)c, (LiCo)lico);
            }
        });
    }

    public void fromJar(BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed() && !lico.getLicense().isPresent()) {
                f.accept((Coordinates)c, (LiCo)lico);
            }
        });
    }

    public void setLog(Findings log) {
        this.log = log;
    }

    public boolean andIsOr() {
        return this.andIsOr;
    }

    public void setAndIsOr(boolean andIsOr) {
        if (this.andIsOr != andIsOr) {
            this.list.forEach((c, coli) -> coli.setLicense(MappedLicense.empty()));
        }
        this.andIsOr = andIsOr;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class LiCo {
        private Optional<String> license = Optional.empty();
        private String licenseReason = "";
        private Optional<CopyrightHolder> copyrightHolder = Optional.empty();
        private String holderReason = "";
        private String scope = "plugin";
        private String message = "";
        private String licenseTxt = "";
        private String headerTxt = "";
        private transient boolean used = false;

        public Optional<String> getLicense() {
            return this.license;
        }

        public Optional<CopyrightHolder> getCopyrightHolder() {
            return this.copyrightHolder;
        }

        public void setLicense(MappedLicense mlicense) {
            mlicense.ifPresent((ConsumerE<LicenseID, Exception>)((ConsumerE)l -> {
                this.license = Optional.of(l.toString());
                this.licenseReason = mlicense.getReason();
            }));
            if (!mlicense.isPresent()) {
                this.licenseReason = "";
                this.license = Optional.empty();
            }
        }

        public String getScope() {
            return this.scope;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean isUsed() {
            return this.used;
        }

        public Optional<CopyrightHolder> getHolder() {
            return this.copyrightHolder;
        }

        public String getMessage() {
            return this.message;
        }

        public void setHolder(Optional<CopyrightHolder> holder) {
            this.copyrightHolder = holder;
        }

        public void setLicenseTxt(String licenseTxt) {
            this.licenseTxt = licenseTxt;
        }

        public void setHeaderTxt(String headerTxt) {
            this.headerTxt = headerTxt;
        }

        public String getLicenseReason() {
            return this.licenseReason;
        }
    }
}

