/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.buildup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class JSONStartup {
    public static LOracle start() {
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = (InputStream)NonnullCheck._nn((Object)JSONStartup.class.getResourceAsStream("/de/pfabulist/loracle/loracle.json"));){
            int once;
            while ((once = in.read(buf, got, 3000000 - got)) >= 0) {
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        String jsonstr = new String(buf, 0, got, StandardCharsets.UTF_8);
        return (LOracle)new Gson().fromJson(jsonstr, LOracle.class);
    }

    public static Coordinates2License previous(boolean andIsOr) {
        Path previuos = JSONStartup.getLoracleJson();
        if (!Files.exists(previuos, new LinkOption[0])) {
            Coordinates2License ret = new Coordinates2License();
            ret.setAndIsOr(andIsOr);
            return ret;
        }
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = (InputStream)NonnullCheck._nn((Object)Files.newInputStream(previuos, new OpenOption[0]));){
            int once;
            while ((once = in.read(buf, got, 3000000 - got)) >= 0) {
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        String jsonstr = new String(buf, 0, got, StandardCharsets.UTF_8);
        Coordinates2License ret = (Coordinates2License)new Gson().fromJson(jsonstr, Coordinates2License.class);
        ret.setAndIsOr(andIsOr);
        return ret;
    }

    public static void previousOut(Coordinates2License c2l) {
        Path previous = JSONStartup.getLoracleJson();
        Gson gson = new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().create();
        Filess.write((Path)previous, (byte[])Strings.getBytes((String)gson.toJson((Object)c2l)), (OpenOption[])new OpenOption[0]);
    }

    private static Path getLoracleJson() {
        Path previous = (Path)NonnullCheck._nn((Object)Paths.get("target/loracle/loracle.json", new String[0]).toAbsolutePath());
        Filess.createDirectories((Path)((Path)NonnullCheck._nn((Object)previous.getParent())), (FileAttribute[])new FileAttribute[0]);
        return previous;
    }
}

