/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.attribution;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.nio.Filess;
import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.Header;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SrcAccess {
    private final LOracle lOracle;
    private final MavenLicenseOracle mlo;
    private final Findings log;
    private static Pattern javaPattern = Frex.any().zeroOrMore().then(Frex.txt((String)".java")).buildCaseInsensitivePattern();
    static Pattern copyRightPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Copyright ")}).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'-'), Frex.txt((char)','), Frex.whitespace()}).oneOrMore().var("year")).then((Frex)Frex.txt((char)' ')).then(Frex.anyBut((CharacterClass)Frex.txt((char)'\n')).oneOrMore().var("holder")).buildCaseInsensitivePattern();

    public SrcAccess(LOracle lOracle, MavenLicenseOracle mlo, Findings log) {
        this.lOracle = lOracle;
        this.mlo = mlo;
        this.log = log;
    }

    public void check(Coordinates coo, Coordinates2License.LiCo lico) {
        Path src = this.mlo.getSrc(coo);
        if (!Files.exists(src, new LinkOption[0])) {
            this.log.warn("no src available " + coo);
            this.log.warn("[try] mvn dependency:source");
            return;
        }
        try (InputStream in = Filess.newInputStream((Path)src, (OpenOption[])new OpenOption[0]);){
            String file = GetHolder.unzipToString(in, javaPattern);
            if (file.isEmpty()) {
                this.log.warn("artifact source" + coo + " has no java file");
                return;
            }
            lico.setHeaderTxt(Header.getHeader(file));
            Matcher matcher = copyRightPattern.matcher(file);
            if (matcher.find()) {
                CopyrightHolder ch = new CopyrightHolder((String)NonnullCheck._nn((Object)matcher.group("year")), (String)NonnullCheck._nn((Object)matcher.group("holder")));
                this.log.info("" + coo + " -> " + ch);
                lico.setHolder(Optional.of(ch));
                return;
            }
        }
        catch (IOException e) {
            this.log.warn((CharSequence)NonnullCheck._orElseGet((Object)e.getMessage(), (Object)"pattern problem"));
        }
    }
}

