/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseFromText;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Downloader;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.roast.functiontypes.Consumerr;

public class UrlToLicense {
    private final LOracle lOracle;
    private final Findings log;
    private final Downloader downloader;
    private final LicenseFromText lft;

    public UrlToLicense(LOracle lOracle, Findings log) {
        this.lOracle = lOracle;
        this.log = log;
        this.downloader = new Downloader(log, lOracle);
        this.lft = new LicenseFromText(lOracle, log);
    }

    public MappedLicense getLicense(String url) {
        MappedLicense ret = this.lOracle.getByUrl(url);
        if (ret.isPresent()) {
            return ret;
        }
        this.downloader.download(url);
        String txt = this.downloader.get(url);
        if (txt.isEmpty()) {
            return MappedLicense.empty();
        }
        ret = this.lft.getLicense(txt);
        ret.ifPresent((Consumerr<LicenseID>)((Consumerr)lid -> {
            this.log.debug("added extension url for license " + url);
            this.lOracle.addUrl((LicenseID)lid, url);
        }));
        return ret;
    }
}

