/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.functiontypes.Functionn;
import de.pfabulist.roast.nio.Filess;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.logging.Log;

public class MavenLicenseOracle {
    private final Log log;
    private final Path localRepo;

    public MavenLicenseOracle(Log log, Path localRepo) {
        this.log = log;
        this.localRepo = localRepo;
    }

    public List<License> getMavenLicense(Coordinates coo) {
        while (true) {
            Path pom;
            List<License> licenses;
            if (!(licenses = this.extractLicense(pom = this.getPom(coo))).isEmpty()) {
                this.log.debug((CharSequence)"      licenses found ");
                licenses.forEach(l -> this.log.debug((CharSequence)("         " + (String)NonnullCheck._orElseGet((Object)l.getName(), (Object)"-") + " : " + (String)NonnullCheck._orElseGet((Object)l.getUrl(), (Object)"-"))));
                return licenses;
            }
            this.log.debug((CharSequence)("    no licenses found in " + coo));
            Optional<Coordinates> parentCoo = this.extractParent(pom);
            if (!parentCoo.isPresent()) break;
            coo = (Coordinates)NonnullCheck._nn((Object)parentCoo.get());
            this.log.debug((CharSequence)("          going to parent: " + coo));
        }
        this.log.debug((CharSequence)"          no parent, i,e. no license found");
        return Collections.emptyList();
    }

    public Path getPom(Coordinates coords) {
        return (Path)NonnullCheck._nn((Object)coords.getSnapshotTolerantDir(this.localRepo).resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".pom"));
    }

    public Path getArtifactOld(Coordinates coords) {
        Path ret = this.localRepo;
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getGroupId().replace('.', '/')));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getVersion()));
        ret = (Path)NonnullCheck._nn((Object)ret.resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".jar"));
        return ret;
    }

    public Path getArtifact(Coordinates coords) {
        Path dir = coords.getSnapshotTolerantDir(this.localRepo);
        Pattern pattern = Frex.txt((String)((Path)NonnullCheck._nn((Object)dir.resolve(coords.getArtifactId() + "-" + coords.getVersion()))).toString()).then(Frex.or((Frex[])new Frex[]{Frex.alphaNum(), Frex.txt((char)'-')}).zeroOrMore().group("suffix")).then(Frex.txt((String)".jar")).buildCaseInsensitivePattern();
        Path classic = (Path)NonnullCheck._nn((Object)dir.resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".jar"));
        if (!Files.exists(dir, new LinkOption[0])) {
            return classic;
        }
        return Filess.list((Path)dir).filter(p -> {
            Matcher matcher = pattern.matcher(p.toString());
            if (!matcher.find()) {
                return false;
            }
            switch ((String)NonnullCheck._nn((Object)matcher.group("suffix"))) {
                case "-sources": 
                case "-javadoc": {
                    return false;
                }
            }
            return true;
        }).findFirst().orElse(classic);
    }

    public Path getSrc(Coordinates coords) {
        return (Path)NonnullCheck._nn((Object)coords.getSnapshotTolerantDir(this.localRepo).resolve(coords.getArtifactId() + "-" + coords.getVersion() + "-sources.jar"));
    }

    List<License> extractLicense(Path pom) {
        return this.fromPom(pom, m -> Optional.ofNullable(m.getLicenses())).orElse(Collections.emptyList());
    }

    Optional<Coordinates> extractParent(Path pom) {
        return this.fromPom(pom, m -> {
            Parent parent = m.getParent();
            if (parent == null) {
                return Optional.empty();
            }
            return Optional.of(new Coordinates((String)NonnullCheck._nn((Object)parent.getGroupId()), (String)NonnullCheck._nn((Object)parent.getArtifactId()), (String)NonnullCheck._nn((Object)parent.getVersion())));
        });
    }

    /*
     * Exception decompiling
     */
    <T> Optional<T> fromPom(Path pom, Functionn<Model, Optional<T>> func) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

