/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseFromText;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.UrlToLicense;
import java.util.Collections;
import java.util.Optional;

public class LicenseIntelligence {
    private final LOracle lOracle;
    private final Findings log;
    private final UrlToLicense urlToLicense;
    private final LicenseFromText lft;
    private final ContentToLicense contentToLicense;

    public LicenseIntelligence(LOracle lOracle, Findings log) {
        this.lOracle = lOracle;
        this.log = log;
        this.urlToLicense = new UrlToLicense(lOracle, log);
        this.lft = new LicenseFromText(lOracle, log);
        this.contentToLicense = new ContentToLicense(lOracle, log);
    }

    public void compute(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        MappedLicense byCoo = this.computeByCoordinates(coordinates, liCo);
        MappedLicense byPom = this.computeByPom(liCo);
        MappedLicense byLicenseFile = this.computeByLicenseFile(liCo);
        MappedLicense byPomHeader = this.computeByPomHeader(liCo);
        MappedLicense bySrcHeader = this.computeBySrcHeader(liCo);
        MappedLicense byNotice = this.computeByNotice(liCo);
        MappedLicense sum = MappedLicense.decide(byCoo, byPom, byLicenseFile, byPomHeader, bySrcHeader, byNotice);
        if (sum.isPresent()) {
            liCo.setLicense(sum);
            return;
        }
        this.log.debug("searching in in content for " + coordinates);
        MappedLicense byPomHeaderWords = this.contentToLicense.findLicenses(liCo.getPomHeader(), "by pom header");
        liCo.setPomHeaderLicense(byPomHeaderWords);
        MappedLicense byLicenseFileWords = this.contentToLicense.findLicenses(liCo.getLicenseTxt(), "by license file");
        liCo.setLicenseTxtLicense(byLicenseFileWords);
        MappedLicense byHeaderWords = this.contentToLicense.findLicenses(liCo.getHeaderTxt(), "by file header");
        liCo.setHeaderLicense(byHeaderWords);
        MappedLicense byNoticeWords = this.contentToLicense.findLicenses(liCo.getNotice(), "by notice");
        liCo.setNoticeLicense(byNoticeWords);
        sum = MappedLicense.decide(byCoo, byPom, byPomHeaderWords, byLicenseFileWords, byHeaderWords, byNoticeWords);
        liCo.setLicense(sum);
        this.log.debug("done found?: " + sum.toString());
    }

    private MappedLicense computeByNotice(Coordinates2License.LiCo liCo) {
        MappedLicense byNotice = this.lft.getLicense(liCo.getNotice());
        if (byNotice.isPresent()) {
            liCo.setNoticeLicense(byNotice);
        }
        return byNotice;
    }

    private MappedLicense computeBySrcHeader(Coordinates2License.LiCo liCo) {
        MappedLicense bySrcHeader = this.lft.getLicense(liCo.getHeaderTxt());
        if (bySrcHeader.isPresent()) {
            liCo.setHeaderLicense(bySrcHeader);
        }
        return bySrcHeader;
    }

    private MappedLicense computeByPomHeader(Coordinates2License.LiCo liCo) {
        MappedLicense license = this.lft.getLicense(liCo.getPomHeader());
        if (license.isPresent()) {
            liCo.setPomHeaderLicense(license);
        }
        return license;
    }

    private MappedLicense computeByLicenseFile(Coordinates2License.LiCo liCo) {
        MappedLicense byLicenseFile = this.lft.getLicense(liCo.getLicenseTxt());
        if (byLicenseFile.isPresent()) {
            liCo.setLicenseTxtLicense(byLicenseFile);
        }
        return byLicenseFile;
    }

    private MappedLicense computeByPom(Coordinates2License.LiCo liCo) {
        MappedLicense byPom = liCo.getMavenLicenses().stream().map(this::mavenLicenseToLicense).reduce(MappedLicense.empty(), (a, b) -> new And(this.lOracle, this.log, true).and((MappedLicense)a, (MappedLicense)b));
        liCo.setPomLicense(byPom);
        return byPom;
    }

    private MappedLicense computeByCoordinates(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        MappedLicense byCoo = this.lOracle.getByCoordinates(coordinates);
        liCo.setByCoordinates(byCoo);
        if (!byCoo.isPresent()) {
            Optional<String> url = this.lOracle.getUrlFromCoordinates(coordinates);
            url.ifPresent(u -> liCo.setMavenLicenses(Collections.singletonList(new Coordinates2License.MLicense("", (String)u, ""))));
        }
        return byCoo;
    }

    public MappedLicense mavenLicenseToLicense(Coordinates2License.MLicense mavenLicense) {
        Optional<String> name = Optional.of(mavenLicense.getName());
        MappedLicense byName = name.map(this.lOracle::getByName).orElse(MappedLicense.empty());
        Optional<String> url = Optional.of(mavenLicense.getUrl());
        MappedLicense byUrl = url.map(this.urlToLicense::getLicense).orElse(MappedLicense.empty());
        MappedLicense byComments = this.contentToLicense.findLicenses(mavenLicense.getComment(), "comments");
        mavenLicense.setByName(byName);
        mavenLicense.setByUrl(byUrl);
        mavenLicense.setByComment(byComments);
        return MappedLicense.decide(byName, byUrl, byComments);
    }
}

