/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.attribution.GetHolder;
import de.pfabulist.loracle.attribution.JarAccess;
import de.pfabulist.loracle.attribution.SrcAccess;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.ContentToLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.mojo.Downloader;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.LicenseIntelligence;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.loracle.mojo.UrlDeclaration;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.functiontypes.Supplierr;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class LicenseCheckMojo {
    private final Findings log;
    private final MavenLicenseOracle mlo;
    private final LOracle lOracle;
    private final MavenProject mavenProject;
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final LicenseIntelligence licenseIntelligence;
    private final Downloader downloader;
    private final ContentToLicense contentToLicense;
    private Optional<Coordinates> self = Optional.empty();
    private final Coordinates2License coordinates2License;
    private final SrcAccess src;
    private final JarAccess jarAccess;
    private final SrcAccess srcAccess;

    public LicenseCheckMojo(Findings log, Path localRepo, MavenProject project, DependencyGraphBuilder dependencyGraphBuilder) {
        this.log = log;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.mlo = new MavenLicenseOracle(log, localRepo);
        this.lOracle = JSONStartup.start().spread();
        this.mavenProject = project;
        log.info("---------------------------------------");
        log.info("      loracle license check            ");
        log.info("---------------------------------------");
        this.coordinates2License = JSONStartup.previous();
        this.coordinates2License.setLog(log);
        this.licenseIntelligence = new LicenseIntelligence(this.lOracle, log);
        this.downloader = new Downloader(log, this.lOracle);
        this.contentToLicense = new ContentToLicense(this.lOracle, log);
        this.src = new SrcAccess(this.lOracle, this.mlo, log);
        this.jarAccess = new JarAccess(this.lOracle, this.mlo, log);
        this.srcAccess = new SrcAccess(this.lOracle, this.mlo, log);
    }

    public void config(List<LicenseDeclaration> licenseDeclarations, List<UrlDeclaration> urlDeclarations, int allowUrlsCheckedDaysBefore) {
        this.configLicenseDeclarations(licenseDeclarations);
        this.configUrlDeclarations(urlDeclarations);
    }

    private void configUrlDeclarations(List<UrlDeclaration> urlDeclarations) {
        urlDeclarations.forEach(ud -> {
            LicenseID license = this.lOracle.getOrThrowByName(ud.getLicense());
            this.log.debug("setting " + ud.getUrl() + " -> " + license + ", check at " + ud.getCheckedAt());
        });
    }

    private void configLicenseDeclarations(List<LicenseDeclaration> licenseDeclarations) {
        licenseDeclarations.forEach(excl -> {
            Coordinates coo = excl.getCoordinates();
            LicenseID license = this.lOracle.getOrThrowByName(excl.getLicense());
            this.lOracle.addLicenseForArtifact(coo, license);
            this.log.debug("setting " + coo + " -> " + license);
        });
    }

    public void getDependencies() {
        this.getPluginsAndTheirDependencies();
        this.getNormalDependencies();
    }

    private String getUse(DependencyNode node) {
        Artifact a = (Artifact)NonnullCheck._nn((Object)node.getArtifact());
        String ret = (String)NonnullCheck._orElseGet((Object)a.getScope(), (Object)"");
        for (DependencyNode it = node.getParent(); it != null; it = it.getParent()) {
            Coordinates coo = Coordinates.valueOf((Artifact)NonnullCheck._nn((Object)it.getArtifact()));
            ret = coo.toString() + " -> " + ret;
        }
        return ret;
    }

    private void getNormalDependencies() {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
        DependencyNode rootNode = (DependencyNode)Supplierr.v(() -> this.lambda$getNormalDependencies$121((ArtifactFilter)artifactFilter));
        rootNode.accept(new DependencyNodeVisitor(){

            public boolean visit(DependencyNode dependencyNode) {
                Artifact a = (Artifact)NonnullCheck._nn((Object)((DependencyNode)NonnullCheck._nn((Object)dependencyNode)).getArtifact());
                Coordinates coo = Coordinates.valueOf(a);
                LicenseCheckMojo.this.coordinates2License.add(coo);
                LicenseCheckMojo.this.coordinates2License.updateScope(coo, (String)NonnullCheck._orElseGet((Object)a.getScope(), (Object)"compile"));
                LicenseCheckMojo.this.coordinates2License.addUse(coo, LicenseCheckMojo.this.getUse((DependencyNode)NonnullCheck._nn((Object)dependencyNode)));
                if (!LicenseCheckMojo.this.self.isPresent()) {
                    LicenseCheckMojo.this.self = Optional.of(coo);
                    LicenseCheckMojo.this.coordinates2License.setSelf(coo);
                }
                return true;
            }

            public boolean endVisit(DependencyNode dependencyNode) {
                return true;
            }
        });
    }

    private void getPluginsAndTheirDependencies() {
        ((Build)NonnullCheck._nn((Object)this.mavenProject.getBuild())).getPlugins().forEach(plugin -> {
            Coordinates plugCoo = new Coordinates((String)NonnullCheck._nn((Object)plugin.getGroupId()), (String)NonnullCheck._nn((Object)plugin.getArtifactId()), (String)NonnullCheck._nn((Object)plugin.getVersion()));
            this.coordinates2License.add(plugCoo);
            this.coordinates2License.updateScope(plugCoo, "plugin");
            List deps = (List)NonnullCheck._nn((Object)plugin.getDependencies());
            deps.forEach(d -> {
                Coordinates dCoo = new Coordinates((String)NonnullCheck._nn((Object)d.getGroupId()), (String)NonnullCheck._nn((Object)d.getArtifactId()), (String)NonnullCheck._nn((Object)d.getVersion()));
                this.coordinates2License.add(dCoo);
                this.coordinates2License.updateScope(dCoo, "plugin");
            });
        });
    }

    public void determineMavenLicenses() {
        this.log.debug("-- determine licenses --");
        this.coordinates2License.update(this::getMavenLicenseInfo);
    }

    private void getMavenLicenseInfo(Coordinates coo, Coordinates2License.LiCo lico) {
        List<License> mavenLicenses = this.mlo.getMavenLicense(coo);
        lico.setMLicenses(mavenLicenses.stream().map(l -> new Coordinates2License.MLicense((String)NonnullCheck._orElseGet((Object)l.getName(), (Object)""), (String)NonnullCheck._orElseGet((Object)l.getUrl(), (Object)""), (String)NonnullCheck._orElseGet((Object)l.getComments(), (Object)""))).collect(Collectors.toList()));
    }

    public String checkCompatibility(Coordinates coo, String licenseStr) {
        LicenseID license = this.lOracle.getOrThrowByName(licenseStr);
        AtomicReference<String> ret = new AtomicReference<String>("");
        this.lOracle.getAttributes(license).isFedoraApproved().ifPresent(fed -> {
            if (!fed.booleanValue()) {
                ret.set("bad license " + license + " used by: " + coo + "  (not approved by fedora)");
            }
        });
        if (!this.self.isPresent()) {
            return "";
        }
        Optional<Coordinates2License.LiCo> info = this.coordinates2License.get((Coordinates)NonnullCheck._nn((Object)this.self.get()));
        if (!info.isPresent() || !((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().isPresent()) {
            return "no license on current artifact";
        }
        LicenseID mine = this.lOracle.getOrThrowByName((String)NonnullCheck._nn((Object)((Coordinates2License.LiCo)NonnullCheck._nn((Object)info.get())).getLicense().get()));
        if (mine.equals(license)) {
            return "";
        }
        if (this.lOracle.getAttributes(mine).isCopyLeftDef()) {
            this.lOracle.getAttributes(license).isGpl2Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
            this.lOracle.getAttributes(license).isGpl3Compatible().ifPresent(gc -> {
                if (!gc.booleanValue()) {
                    ret.set("not gpl2 compatible: " + license + " used by " + coo);
                }
            });
        }
        if (!this.lOracle.getAttributes(mine).isCopyLeftDef() && this.lOracle.getAttributes(license).isCopyLeftDef()) {
            ret.set("can't depend on a copy left license: " + license + " used by " + coo);
        }
        return (String)NonnullCheck._nn((Object)ret.get());
    }

    public void checkCompatibility() {
        this.coordinates2License.checkCompatibility(this::checkCompatibility);
    }

    public void getHolder() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.getHolders(gh::getHolder);
    }

    public void summery() {
        this.coordinates2License.summery();
    }

    public void src() {
        this.coordinates2License.fromSrc(this.srcAccess::check);
    }

    public void store() {
        JSONStartup.previousOut(this.coordinates2License);
    }

    public void jars() {
        this.coordinates2License.fromJar(this.jarAccess::check);
    }

    public void computeHolder() {
        this.coordinates2License.update(this::computeHolder);
    }

    private void computeHolder(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        Optional<CopyrightHolder> ret = liCo.getMavenLicenses().stream().map(ml -> ContentToLicense.copyRightPattern.matcher((CharSequence)NonnullCheck._orElseGet((Object)ml.getComment(), (Object)""))).filter(Matcher::matches).map(m -> new CopyrightHolder((String)NonnullCheck._nn((Object)m.group("year")), (String)NonnullCheck._nn((Object)m.group("holder")))).findAny();
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = this.contentToLicense.getHolder(liCo.getLicenseTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = this.contentToLicense.getHolder(liCo.getHeaderTxt());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
            return;
        }
        ret = this.contentToLicense.getHolder(liCo.getNotice());
        if (ret.isPresent()) {
            liCo.setHolder(ret);
        }
    }

    public void getNotice() {
        GetHolder gh = new GetHolder(this.lOracle, this.mlo, this.log);
        this.coordinates2License.update(gh::getNotice);
    }

    public void getPomHeader() {
        this.coordinates2License.fromSrc(this.src::getPomHeader);
    }

    public void generateNotice() {
        this.coordinates2License.generateNotice();
    }

    public void computeLicense() {
        this.coordinates2License.update(this.licenseIntelligence::compute);
    }

    public void downloadPages() {
        this.coordinates2License.update(this.downloader::getExtension);
    }

    public void generateLicenseTxts() {
        this.coordinates2License.update(lico -> Coordinates2License.getScopeLevel(lico.getScope()) < Coordinates2License.getScopeLevel("test"), (coo, lico) -> this.downloader.generateLicensesTxt(this.self.map(Coordinates::getArtifactId).orElse("notice"), (Coordinates)coo, (Coordinates2License.LiCo)lico));
    }

    private /* synthetic */ DependencyNode lambda$getNormalDependencies$121(ArtifactFilter artifactFilter) throws DependencyGraphBuilderException {
        return (DependencyNode)NonnullCheck._nn((Object)this.dependencyGraphBuilder.buildDependencyGraph(this.mavenProject, artifactFilter));
    }
}

