/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseCheckMojo;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.UrlDeclaration;
import de.pfabulist.roast.NonnullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;

@SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
@Mojo(name="license-check", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class LOracleMojo
extends AbstractMojo {
    @Nullable
    @Component
    DependencyGraphBuilder dependencyGraphBuilder;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(property="license-check.ikwid")
    List<LicenseDeclaration> licenseDeclarations;
    @Nullable
    @Parameter(property="license-check.urldeclarations")
    List<UrlDeclaration> urlDeclarations;
    @Parameter(property="license-check.stopOnError", defaultValue="true")
    boolean stopOnError;
    @Parameter(property="license-check.andIsOr", defaultValue="true")
    boolean andIsOr;
    @Parameter(property="license-check.allowUrlsCheckedDaysBefore", defaultValue="-1000")
    int allowUrlsCheckedDaysBefore;
    @Nullable
    private Findings failures;

    public DependencyGraphBuilder getDependencyGraphBuilder() {
        return (DependencyGraphBuilder)NonnullCheck._nn((Object)this.dependencyGraphBuilder);
    }

    public MavenProject getProject() {
        return (MavenProject)NonnullCheck._nn((Object)this.project);
    }

    public MavenSession getSession() {
        return (MavenSession)NonnullCheck._nn((Object)this.session);
    }

    public List<LicenseDeclaration> getLicenseDeclarations() {
        return this.licenseDeclarations == null ? Collections.emptyList() : this.licenseDeclarations;
    }

    public List<UrlDeclaration> getUrlDeclarations() {
        return this.urlDeclarations == null ? Collections.emptyList() : this.urlDeclarations;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block3: {
            try {
                LicenseCheckMojo mojo = new LicenseCheckMojo(this.getLog(), Paths.get(((ArtifactRepository)NonnullCheck._nn((Object)this.getSession().getLocalRepository())).getBasedir(), new String[0]), this.getProject(), this.getDependencyGraphBuilder());
                mojo.config(this.getLicenseDeclarations(), this.getUrlDeclarations(), this.allowUrlsCheckedDaysBefore);
                mojo.getDependencies();
                mojo.determineMavenLicenses();
                mojo.jars();
                mojo.src();
                mojo.getNotice();
                mojo.getPomHeader();
                mojo.downloadPages();
                mojo.computeLicense();
                mojo.computeHolder();
                mojo.checkCompatibility();
                mojo.summery();
                mojo.generateLicenseTxts();
                mojo.generateNotice();
                mojo.store();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.stopOnError) break block3;
                throw new MojoFailureException(e.getMessage());
            }
        }
        if (this.stopOnError) {
            this.getLog().throwOnError();
        }
    }

    public Findings getLog() {
        if (this.failures == null) {
            this.failures = new Findings(super.getLog());
        }
        return this.failures;
    }
}

