/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import com.google.gson.Gson;
import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseIDs;
import de.pfabulist.loracle.license.Normalizer;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.functiontypes.Consumerr;
import de.pfabulist.roast.nio.Filess;
import de.pfabulist.roast.nio.Pathh;
import de.pfabulist.roast.nio.Pathss;
import de.pfabulist.roast.unchecked.Unchecked;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;

public class Downloader {
    private final Findings log;
    Normalizer normalizer = new Normalizer();
    private final LOracle lOracle;
    private static final String urlspecial = Frex.txt((char)':').or((CharacterClass)Frex.txt((char)'/')).or((CharacterClass)Frex.txt((char)'*')).or((CharacterClass)Frex.txt((char)'\"')).or((CharacterClass)Frex.txt((char)'<')).or((CharacterClass)Frex.txt((char)'>')).or((CharacterClass)Frex.txt((char)'?')).or((CharacterClass)Frex.txt((char)'\\')).buildPattern().toString();

    public Downloader(Findings log, LOracle lOracle) {
        this.log = log;
        this.lOracle = lOracle;
    }

    public void get(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        if (!liCo.getLicenseTxt().isEmpty()) {
            return;
        }
        if (liCo.getMavenLicenses().isEmpty()) {
            Downloader.getLico(coordinates).ifPresent(stored -> {
                if (stored.getMavenLicenses().isEmpty() || ((Coordinates2License.MLicense)NonnullCheck._nn((Object)stored.getMavenLicenses().get(0))).getUrl().isEmpty()) {
                    this.log.warn("[huh]");
                    return;
                }
                liCo.setMavenLicenses(stored.getMavenLicenses());
                this.log.debug("found stored information for " + coordinates);
            });
        }
        liCo.getMavenLicenses().stream().map(Coordinates2License.MLicense::getUrl).filter(u -> !u.isEmpty()).forEach(this::download);
    }

    public void getExtension(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        if (!liCo.getLicenseTxt().isEmpty()) {
            return;
        }
        Downloader.getLico(coordinates).ifPresent(stored -> {
            liCo.setMavenLicenses(stored.getMavenLicenses());
            this.log.debug("found stored information for " + coordinates);
        });
    }

    public void download(String url) {
        this.log.debug("[download?] " + url);
        Pathh path = Pathss.get((String)"", (String[])new String[0]).resolve("target/generated-sources/loracle/url/" + this.getUrlPath(url));
        if (Filess.exists((Pathh)path, (LinkOption[])new LinkOption[0])) {
            return;
        }
        Filess.createDirectories((Pathh)path.getParentOrThrow(), (FileAttribute[])new FileAttribute[0]);
        Optional<String> res = this.lOracle.getUrlContent(url);
        if (!res.isPresent()) {
            this.log.debug("    url not stored: " + url);
            return;
        }
        try (InputStream is = this.getClass().getResourceAsStream(res.get());){
            if (is == null) {
                this.log.debug("    not found: " + this.getUrlPath(url));
                return;
            }
            Filess.copy((InputStream)is, (Pathh)path, (CopyOption[])new CopyOption[0]);
            this.log.debug("    found stored in loracle");
            return;
        }
        catch (IOException iOException) {
            this.log.warn("       not found " + url);
            this.log.warn("[try]  add page src as resource see loracle-custom");
            return;
        }
    }

    private String getUrlPath(String url) {
        String u = this.normalizer.normalizeUrl(url).orElse(url);
        return u.replaceAll(urlspecial, "_");
    }

    public String get(String u) {
        Path path = (Path)NonnullCheck._nn((Object)Paths.get("", new String[0]).resolve("target/generated-sources/loracle/url/" + this.getUrlPath(u)));
        if (!Files.exists(path, new LinkOption[0])) {
            return "";
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.log.debug("[huh url?] " + path);
            return "";
        }
        return Strings.newString((byte[])Filess.readAllBytes((Path)path));
    }

    public void setNoInternet() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Coordinates2License.LiCo> getLico(Coordinates coo) {
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = JSONStartup.class.getResourceAsStream("/de/pfabulist/loracle/coordinates/" + coo.toFilename() + ".json");){
            int once;
            if (in == null) {
                Optional<Coordinates2License.LiCo> optional = Optional.empty();
                return optional;
            }
            while ((once = in.read(buf, got, 3000000 - got)) >= 0) {
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
        String jsonstr = new String(buf, 0, got, StandardCharsets.UTF_8);
        return Optional.of(new Gson().fromJson(jsonstr, Coordinates2License.LiCo.class));
    }

    public void generateLicensesTxt(String prefix, Coordinates coordinates, Coordinates2License.LiCo liCo) {
        Path src = (Path)NonnullCheck._nn((Object)Paths.get("target/generated-sources/loracle/coordinates/" + coordinates.toFilename() + "/license-0.txt", new String[0]).toAbsolutePath());
        if (Files.exists(src, new LinkOption[0]) && Filess.size((Path)src) > 0L) {
            String fname = coordinates.toFilename() + "-license.txt";
            this.getEmptyNoticeLicenseTarget(prefix, coordinates.toFilename() + "-license.txt").ifPresent(tgt -> Filess.copy((Path)src, (Path)tgt, (CopyOption[])new CopyOption[0]));
            liCo.setLicenseFilenames(Collections.singletonList(fname));
            return;
        }
        ArrayList<String> fnames = new ArrayList<String>();
        liCo.getLicense().ifPresent(li -> this.lOracle.getByName((String)li).ifPresent((Consumerr<LicenseID>)((Consumerr)license -> LicenseIDs.flattenToStrings(license).forEach(lstr -> {
            String fname = this.onPredefLicense((String)lstr, (filename, is) -> this.getEmptyNoticeLicenseTarget(prefix, (String)filename).ifPresent(tgt -> Filess.copy((InputStream)is, (Path)tgt, (CopyOption[])new CopyOption[0]))).orElseGet(() -> this.onUrldefLicense((String)lstr, (filename, is) -> this.getEmptyNoticeLicenseTarget(prefix, (String)filename).ifPresent(tgt -> Filess.copy((InputStream)is, (Path)tgt, (CopyOption[])new CopyOption[0]))).orElse(""));
            if (fname.isEmpty()) {
                this.log.warn("can not find text for " + lstr);
            } else {
                fnames.add(fname);
            }
        }))));
        liCo.setLicenseFilenames(fnames);
    }

    private Optional<Path> getEmptyNoticeLicenseTarget(String prefix, String fname) {
        String filename = prefix + "/" + fname;
        Path tgt = (Path)NonnullCheck._nn((Object)Paths.get("target/generated-sources/loracle/licenses/" + filename, new String[0]).toAbsolutePath());
        if (Files.exists(tgt, new LinkOption[0])) {
            return Optional.empty();
        }
        Filess.createDirectories((Path)((Path)NonnullCheck._nn((Object)tgt.getParent())), (FileAttribute[])new FileAttribute[0]);
        return Optional.of(tgt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public Optional<String> onPredefLicense(String lstr, BiConsumer<String, InputStream> isConsumer) {
        String fname = Normalizer.toFilename(lstr) + ".txt";
        try (InputStream is = Downloader.class.getResourceAsStream("/de/pfabulist/loracle/urls/" + fname);){
            if (is == null) {
                this.log.debug("no prefdef license text found for: " + lstr);
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            isConsumer.accept(fname, is);
            Optional<String> optional = Optional.of(fname);
            return optional;
        }
        catch (Exception e) {
            this.log.debug("no prefdef license text found for: " + lstr);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public Optional<String> onUrldefLicense(String str, BiConsumer<String, InputStream> isConsumer) {
        Optional<LicenseID> olicense = this.lOracle.getByName(str).noReason();
        if (!olicense.isPresent()) {
            return Optional.empty();
        }
        LicenseID license = (LicenseID)NonnullCheck._nn((Object)olicense.get());
        Optional<String> ourl = this.lOracle.getMore((LicenseID)license).urls.stream().filter(u -> this.lOracle.getUrlContent((String)u).isPresent()).findFirst();
        if (!ourl.isPresent()) {
            return Optional.empty();
        }
        String url = (String)NonnullCheck._nn((Object)ourl.get());
        String fname = Normalizer.toFilename(url) + ".txt";
        String res = (String)NonnullCheck._nn((Object)this.lOracle.getUrlContent(url).get());
        try (InputStream is = Downloader.class.getResourceAsStream(res);){
            if (is == null) {
                this.log.warn("urlcontent but no resource " + url);
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            isConsumer.accept(fname, is);
            Optional<String> optional = Optional.of(fname);
            return optional;
        }
        catch (Exception e) {
            this.log.warn("urlcontent but no resource " + url);
            return Optional.empty();
        }
    }
}

