/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseExclude;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.SingleLicense;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import javax.annotation.Nullable;

public class ModifiedSingleLicense
implements LicenseID {
    private final String base;
    private final boolean orLater;
    private final Optional<LicenseExclude> exception;

    ModifiedSingleLicense(SingleLicense singleLicense, boolean orLater, Optional<LicenseExclude> exception) {
        this.exception = exception;
        this.base = singleLicense.getId();
        this.orLater = orLater;
    }

    @Override
    public String getId() {
        return this.base + (this.orLater ? "+" : "") + this.exception.map(e -> " with " + e).orElse("");
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedSingleLicense that = (ModifiedSingleLicense)o;
        if (this.orLater != that.orLater) {
            return false;
        }
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.exception.equals(that.exception);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + (this.orLater ? 1 : 0);
        result = 31 * result + this.exception.hashCode();
        return result;
    }

    public String toString() {
        return this.base + (this.orLater ? "+" : "") + this.exception.map(e -> " with " + e).orElse("");
    }

    public Optional<LicenseExclude> getException() {
        return this.exception;
    }

    public String getBase() {
        return this.base;
    }
}

