/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.SingleLicense;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LicenseIDs {
    public static boolean isOr(LicenseID license) {
        return license instanceof CompositeLicense && ((CompositeLicense)license).isOr();
    }

    public static boolean isAnd(LicenseID license) {
        return license instanceof CompositeLicense && ((CompositeLicense)license).isAnd();
    }

    public static List<String> flattenToStrings(LicenseID license) {
        if (license instanceof CompositeLicense) {
            CompositeLicense cl = (CompositeLicense)license;
            ArrayList<String> ret = new ArrayList<String>();
            ret.addAll(LicenseIDs.flattenToStrings(cl.getLeft()));
            ret.addAll(LicenseIDs.flattenToStrings(cl.getRight()));
            return ret;
        }
        if (license instanceof SingleLicense) {
            return Collections.singletonList(license.toString());
        }
        if (license instanceof ModifiedSingleLicense) {
            ModifiedSingleLicense msl = (ModifiedSingleLicense)license;
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(msl.getBase());
            msl.getException().ifPresent(ex -> ret.add(ex.toString()));
            return ret;
        }
        return Collections.emptyList();
    }
}

