/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.functiontypes.Consumerr;
import de.pfabulist.roast.nio.Filess;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class Coordinates2License {
    private Map<Coordinates, LiCo> list = new HashMap<Coordinates, LiCo>();
    private boolean andIsOr = false;
    @Nullable
    private transient Findings log;
    private transient Optional<Coordinates> self = Optional.empty();

    public void add(Coordinates coo) {
        this.list.putIfAbsent(coo, new LiCo());
        ((LiCo)NonnullCheck._nn((Object)this.list.get(coo))).used = true;
    }

    public void updateScope(Coordinates coo, String scope) {
        if (!this.list.containsKey(coo)) {
            throw new IllegalStateException("no such " + coo);
        }
        LiCo liCo = (LiCo)NonnullCheck._nn((Object)this.list.get(coo));
        String oldScope = (String)NonnullCheck._nn((Object)liCo.scope);
        if (Coordinates2License.getScopeLevel(scope) < Coordinates2License.getScopeLevel(oldScope)) {
            liCo.scope = scope;
        }
    }

    public static int getScopeLevel(String scope) {
        switch (scope) {
            case "plugin": {
                return 8;
            }
            case "import": {
                return 7;
            }
            case "system": {
                return 6;
            }
            case "test": {
                return 5;
            }
            case "runtime": {
                return 4;
            }
            case "provided": {
                return 3;
            }
            case "optional": {
                return 2;
            }
            case "compile": {
                return 1;
            }
        }
        return 100;
    }

    private Findings getLog() {
        return (Findings)NonnullCheck._orElseThrow((Object)this.log, () -> new IllegalStateException("no logger"));
    }

    public void update(BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, coli) -> {
            if (coli.isUsed()) {
                f.accept((Coordinates)c, (LiCo)coli);
            }
        });
    }

    public void update(Predicate<LiCo> pred, BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, coli) -> {
            if (coli.isUsed() && pred.test((LiCo)coli)) {
                f.accept((Coordinates)c, (LiCo)coli);
            }
        });
    }

    public void setSelf(Coordinates coo) {
        this.self = Optional.of(coo);
    }

    public Optional<LiCo> get(Coordinates coordinates) {
        return Optional.ofNullable(this.list.get(coordinates));
    }

    public void checkCompatibility(BiFunction<Coordinates, String, String> f) {
        this.list.forEach((c, coli) -> {
            if (coli.isUsed()) {
                coli.getLicense().ifPresent(l -> {
                    String message = (String)NonnullCheck._nn(f.apply((Coordinates)c, (String)l));
                    if (!message.isEmpty()) {
                        this.scopeDependingLog((Coordinates)c, message);
                    }
                    coli.setMessage(message);
                });
            }
        });
    }

    private void scopeDependingLog(Coordinates coo, String message) {
        String scope = ((LiCo)NonnullCheck._orElseThrow((Object)this.list.get(coo), () -> new IllegalStateException("huh"))).getScope();
        if (!scope.equals("plugin") && !scope.equals("test")) {
            this.getLog().error(message);
        } else {
            this.getLog().warn(message);
        }
    }

    public void summery() {
        this.list.entrySet().stream().filter(e -> Coordinates2License.entryPred(e, (coo, lico) -> lico.isUsed())).sorted((a, b) -> {
            int scope = Coordinates2License.getScopeLevel(((LiCo)NonnullCheck._nn(a.getValue())).getScope()) - Coordinates2License.getScopeLevel(((LiCo)NonnullCheck._nn(b.getValue())).getScope());
            if (scope != 0) {
                return scope;
            }
            return a.toString().compareTo(b.toString());
        }).forEach(e -> {
            Coordinates c = (Coordinates)NonnullCheck._nn(e.getKey());
            LiCo lico = (LiCo)NonnullCheck._nn(e.getValue());
            this.getLog().info(String.format("%-80s %-10s %-50s ", c, lico.getScope(), lico.getLicense().map(Object::toString).orElse("-")) + lico.getHolder().map(Object::toString).orElse("-"));
            if (!lico.getLicense().isPresent()) {
                lico.useedBy.forEach(u -> this.getLog().error("   used by: " + u));
                this.getLog().error("   no license found");
            }
            if (!lico.getMessage().isEmpty()) {
                lico.useedBy.forEach(u -> this.getLog().error("   used by " + u));
                this.getLog().error("   " + lico.getMessage());
            }
            this.getLog().debug("    [sum]              " + lico.getLicenseReason());
            this.getLog().debug("    by Coordinates     " + lico.getByCoordinates());
            this.getLog().debug("    by Pom             " + lico.getPomLicense());
            lico.getMavenLicenses().forEach(ml -> {
                this.getLog().debug("    by Pom Licenses");
                this.getLog().debug("       <");
                if (ml.byName.length() > 2) {
                    this.getLog().debug("                       " + ml.byName);
                } else {
                    this.getLog().debug("                       [-] " + ml.getName());
                }
                if (ml.byUrl.length() > 2) {
                    this.getLog().debug("                       " + ml.byUrl);
                } else {
                    this.getLog().debug("                       [-] " + ml.getUrl());
                }
                if (ml.byComment.length() > 2) {
                    this.getLog().debug("                       " + ml.byComment);
                } else {
                    this.getLog().debug("                       [-] " + ml.getComment());
                }
                this.getLog().debug("       >");
            });
            this.getLog().debug("    by Pom Header      " + (lico.getPomHeader().isEmpty() ? "" : "[+] ") + lico.getPomHeaderLicense());
            this.getLog().debug("    by License Text    " + (lico.getLicenseTxt().isEmpty() ? "" : "[+] ") + lico.getLicenseTextLicense());
            this.getLog().debug("    by Header          " + (lico.getHeaderTxt().isEmpty() ? "" : "[+] ") + lico.getHeaderLicense());
            this.getLog().debug("    by Notice          " + (lico.getNotice().isEmpty() ? "" : "[+] ") + lico.getNoticeLicense());
            this.getLog().debug("\n");
        });
    }

    public void generateNotice() {
        StringBuilder sb = new StringBuilder();
        if (!this.self.isPresent()) {
            sb.append("what ???\n\n");
        } else {
            LiCo selfLico = (LiCo)NonnullCheck._nn((Object)this.get((Coordinates)NonnullCheck._nn((Object)this.self.get())).get());
            sb.append("This is ").append(this.self.map(Object::toString).orElse("?")).append("\n");
            sb.append("it is licensed under:  ").append(selfLico.getLicense().get()).append("\n");
            selfLico.getLicenseFilenames().forEach(fn -> sb.append("see license file:      ").append((String)fn).append("\n"));
            sb.append("copyright holder:      ").append(selfLico.getCopyrightHolder().map(Object::toString).orElse("")).append("\n\n");
            sb.append("It includes the following software:\n\n");
            this.list.entrySet().stream().filter(e -> Coordinates2License.entryPred(e, (coo, lico) -> lico.isUsed() && Coordinates2License.getScopeLevel(lico.getScope()) < Coordinates2License.getScopeLevel("test"))).filter(e -> !((Coordinates)NonnullCheck._nn(e.getKey())).equals(this.self.get())).sorted((a, b) -> Coordinates2License.entryComp(a, b, (cooA, x, cooB, y) -> cooA.toString().compareTo(cooB.toString()))).forEach(Coordinates2License.ec((coo, lico) -> {
                sb.append(coo.getArtifactId()).append("\n").append("   full name:         ").append(coo.toString()).append("\n").append("   licensed under:    ").append(lico.getLicense().map(Object::toString).orElse("-")).append("\n").append("   copyright holder:  ").append(lico.getCopyrightHolder().map(Object::toString).orElse("")).append("\n");
                lico.getLicenseFilenames().forEach(fn -> sb.append("   see license file:  ").append((String)fn).append("\n"));
                sb.append("\n");
            }));
        }
        Path ff = Paths.get("target/generated-sources/loracle/licenses/" + this.self.map(c -> c.getArtifactId() + "/").orElse("") + "NOTICE.txt", new String[0]);
        Filess.createDirectories((Path)((Path)NonnullCheck._nn((Object)ff.getParent())), (FileAttribute[])new FileAttribute[0]);
        Filess.write((Path)ff, (byte[])Strings.getBytes((String)sb.toString()), (OpenOption[])new OpenOption[0]);
    }

    public void getHolders(BiFunction<Coordinates, String, Optional<CopyrightHolder>> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed()) {
                lico.getLicense().ifPresent(l -> lico.setHolder((Optional)NonnullCheck._nn(f.apply((Coordinates)c, (String)l))));
            }
        });
    }

    public void fromSrc(BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed()) {
                f.accept((Coordinates)c, (LiCo)lico);
            }
        });
    }

    public void fromJar(BiConsumer<Coordinates, LiCo> f) {
        this.list.forEach((c, lico) -> {
            if (lico.isUsed() && !lico.getLicense().isPresent()) {
                f.accept((Coordinates)c, (LiCo)lico);
            }
        });
    }

    public void setLog(Findings log) {
        this.log = log;
    }

    public boolean andIsOr() {
        return this.andIsOr;
    }

    public void setAndIsOr(boolean andIsOr) {
        if (this.andIsOr != andIsOr) {
            this.list.forEach((c, coli) -> coli.setLicense(MappedLicense.empty()));
        }
        this.andIsOr = andIsOr;
    }

    public static <K, V> boolean entryPred(Map.Entry<K, V> entry, BiPredicate<K, V> bipred) {
        return bipred.test(entry.getKey(), entry.getValue());
    }

    public static <K, V> void entryConsumer(Map.Entry<K, V> entry, BiConsumer<K, V> func) {
        func.accept(entry.getKey(), entry.getValue());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> ec(BiConsumer<K, V> func) {
        return e -> func.accept(e.getKey(), e.getValue());
    }

    public static <K, V> int entryComp(Map.Entry<K, V> a, Map.Entry<K, V> b, Function4<K, V, K, V, Integer> f4) {
        return f4.apply(NonnullCheck._nn(a.getKey()), NonnullCheck._nn(a.getValue()), NonnullCheck._nn(b.getKey()), NonnullCheck._nn(b.getValue()));
    }

    public void addUse(Coordinates coo, String use) {
        this.get(coo).ifPresent(liCo -> ((LiCo)liCo).useedBy.add(use));
    }

    public static interface Function4<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public static class LiCo {
        private Optional<String> license = Optional.empty();
        private String licenseReason = "";
        private List<MLicense> mavenLicenses = Collections.emptyList();
        private Optional<CopyrightHolder> copyrightHolder = Optional.empty();
        private String holderReason = "";
        private String scope = "plugin";
        private String message = "";
        private String licenseTxt = "";
        private String headerTxt = "";
        private String licenseTxtLicense = "";
        private String headerLicense = "";
        private String pomLicense = "";
        private String byCoordinates = "";
        private String notice = "";
        private String pomHeaderLicense = "";
        private List<String> licenseFilenames = Collections.emptyList();
        private transient boolean used = false;
        private transient List<String> useedBy = new ArrayList<String>();
        private String pomHeader = "";
        private String noticeLicense = "";

        public String getPomHeader() {
            return this.pomHeader;
        }

        public void setPomHeader(String pomHeader) {
            this.pomHeader = pomHeader;
        }

        public void setNoticeLicense(MappedLicense noticeLicense) {
            this.noticeLicense = noticeLicense.toString();
        }

        public Optional<String> getLicense() {
            return this.license;
        }

        public String getNotice() {
            return this.notice;
        }

        public void setNotice(String notice) {
            this.notice = notice;
        }

        public Optional<CopyrightHolder> getCopyrightHolder() {
            return this.copyrightHolder;
        }

        public void setLicense(MappedLicense mlicense) {
            mlicense.ifPresent((Consumerr<LicenseID>)((Consumerr)l -> {
                this.license = Optional.of(l.toString());
                this.licenseReason = mlicense.toString();
            }));
            if (!mlicense.isPresent()) {
                this.licenseReason = "";
                this.license = Optional.empty();
            }
        }

        public String getScope() {
            return this.scope;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean isUsed() {
            return this.used;
        }

        public Optional<CopyrightHolder> getHolder() {
            return this.copyrightHolder;
        }

        public String getMessage() {
            return this.message;
        }

        public void setHolder(Optional<CopyrightHolder> holder) {
            this.copyrightHolder = holder;
        }

        public void setLicenseTxt(String licenseTxt) {
            this.licenseTxt = licenseTxt;
        }

        public void setHeaderTxt(String headerTxt) {
            this.headerTxt = headerTxt;
        }

        public String getLicenseReason() {
            return this.licenseReason;
        }

        public void setMLicenses(List<MLicense> mLicenses) {
            this.mavenLicenses = mLicenses;
        }

        public List<MLicense> getMavenLicenses() {
            return this.mavenLicenses;
        }

        public String getLicenseTxt() {
            return this.licenseTxt;
        }

        public void setLicenseTxtLicense(MappedLicense licenseTxtLicense) {
            this.licenseTxtLicense = licenseTxtLicense.isPresent() ? licenseTxtLicense.toString() : licenseTxtLicense.getReason();
        }

        public void setHeaderLicense(MappedLicense headerLicense) {
            this.headerLicense = headerLicense.isPresent() ? headerLicense.toString() : headerLicense.getReason();
        }

        public String getLicenseTextLicense() {
            return this.licenseTxtLicense;
        }

        public String getHeaderLicense() {
            return this.headerLicense;
        }

        public void setPomLicense(MappedLicense pomLicense) {
            this.pomLicense = pomLicense.isPresent() ? pomLicense.toString() : pomLicense.getReason();
        }

        public String getPomLicense() {
            return this.pomLicense;
        }

        public String getHeaderTxt() {
            return this.headerTxt;
        }

        public void setByCoordinates(MappedLicense byCoordinates) {
            this.byCoordinates = byCoordinates.isPresent() ? byCoordinates.toString() : byCoordinates.getReason();
        }

        public String getByCoordinates() {
            return this.byCoordinates;
        }

        public String getNoticeLicense() {
            return this.noticeLicense;
        }

        public String getPomHeaderLicense() {
            return this.pomHeaderLicense;
        }

        public void setPomHeaderLicense(MappedLicense license) {
            this.pomHeaderLicense = license.toString();
        }

        public void setMavenLicenses(List<MLicense> mavenLicenses) {
            this.mavenLicenses = mavenLicenses;
        }

        public void setLicenseFilenames(List<String> licenseFilenames) {
            this.licenseFilenames = licenseFilenames;
        }

        public List<String> getLicenseFilenames() {
            return this.licenseFilenames;
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class MLicense {
        public String mavenLicenseName = "";
        public String byName = "-";
        public String mavenLicenseUrl = "";
        public String byUrl = "-";
        public String mavenLicenseComment = "";
        public String byComment = "-";

        public MLicense(String mavenLicenseName, String mavenLicenseUrl, String mavenLicenseComment) {
            this.mavenLicenseName = mavenLicenseName;
            this.mavenLicenseUrl = mavenLicenseUrl;
            this.mavenLicenseComment = mavenLicenseComment;
        }

        public String getName() {
            return this.mavenLicenseName;
        }

        public String getUrl() {
            return this.mavenLicenseUrl;
        }

        public String getComment() {
            return this.mavenLicenseComment;
        }

        public void setByName(MappedLicense byName) {
            this.byName = byName.toString();
        }

        public void setByUrl(MappedLicense byUrl) {
            this.byUrl = byUrl.toString();
        }

        public void setByComment(MappedLicense byComment) {
            this.byComment = byComment.toString();
        }
    }
}

