/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.attribution.CopyrightHolder;
import de.pfabulist.loracle.license.And;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.MappedLicense;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.UrlToLicense;
import de.pfabulist.roast.NonnullCheck;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContentToLicense {
    public static final Pattern copyRightPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Copyright ")}).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'-'), Frex.txt((char)','), Frex.whitespace()}).oneOrMore().var("year")).then((Frex)Frex.txt((char)' ')).then((Frex)Frex.txt((String)"(C) ").zeroOrOnce()).then(Frex.anyBut((CharacterClass)Frex.txt((char)'\n')).oneOrMore().var("holder")).buildCaseInsensitivePattern();
    private final LOracle lOracle;
    private final And and;
    private final Findings log;
    private final UrlToLicense urlToLicense;
    public static final Pattern page = Frex.or((Frex[])new Frex[]{Frex.txt((String)"http://"), Frex.txt((String)"https://")}).then(Frex.any().oneOrMore().lazy()).group("addr").then((Frex)Frex.txt((char)'.').zeroOrOnce()).then(Frex.or((Frex[])new Frex[]{Frex.txt((char)' '), Frex.txt((char)'\n'), Frex.txt((char)'\r')})).buildCaseInsensitivePattern();
    private static final Frex ws = Frex.or((Frex[])new Frex[]{Frex.whitespace(), Frex.txt((char)'\n'), Frex.txt((char)'\r')}).oneOrMore();
    private static final Pattern apache2 = Frex.txt((String)"Apache").then(ws).then(Frex.txt((String)"License")).then(ws).then(Frex.txt((String)"Version")).then(ws).then(Frex.txt((String)"2.0")).buildCaseInsensitivePattern();

    public ContentToLicense(LOracle lOracle, Findings log) {
        this.lOracle = lOracle;
        this.and = new And(lOracle, log, true);
        this.log = log;
        this.urlToLicense = new UrlToLicense(lOracle, log);
    }

    public MappedLicense byUrl(String str, String dscr) {
        Matcher matcher = page.matcher(str);
        MappedLicense ret = MappedLicense.empty();
        while (matcher.find()) {
            ret = this.and.and(ret, this.urlToLicense.getLicense((String)NonnullCheck._nn((Object)matcher.group("addr"))).addReason(dscr));
        }
        return ret;
    }

    public MappedLicense findLicenses(String str, String dscr) {
        MappedLicense name = this.lOracle.findLongNames(this.and, str);
        MappedLicense url = this.byUrl(str, dscr);
        return this.and.and(name, url);
    }

    public Optional<CopyrightHolder> getHolder(String str) {
        Matcher matcher = copyRightPattern.matcher(str);
        if (matcher.find()) {
            CopyrightHolder ch = new CopyrightHolder((String)NonnullCheck._nn((Object)matcher.group("year")), (String)NonnullCheck._nn((Object)matcher.group("holder")));
            return Optional.of(ch);
        }
        return Optional.empty();
    }
}

