/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.attribution;

import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.Utils;
import de.pfabulist.loracle.attribution.Header;
import de.pfabulist.loracle.attribution.LicenseWriter;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.Coordinates2License;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.nio.Filess;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class SrcAccess {
    private final LOracle lOracle;
    private final MavenLicenseOracle mlo;
    private final Findings log;
    private static Pattern javaPattern = Frex.any().zeroOrMore().then(Frex.or((Frex[])new Frex[]{Frex.txt((String)".scala"), Frex.txt((String)".java")})).buildCaseInsensitivePattern();

    public SrcAccess(LOracle lOracle, MavenLicenseOracle mlo, Findings log) {
        this.lOracle = lOracle;
        this.mlo = mlo;
        this.log = log;
    }

    public void check(Coordinates coo, Coordinates2License.LiCo lico) {
        Path src = this.mlo.getSrc(coo);
        if (!Files.exists(src, new LinkOption[0])) {
            this.log.warn("no src available " + coo);
            this.log.warn("[try] mvn dependency:source");
            return;
        }
        try (InputStream in = Filess.newInputStream((Path)src, (OpenOption[])new OpenOption[0]);){
            String file = Utils.unzipToString(in, javaPattern);
            if (file.isEmpty()) {
                this.log.warn("artifact source" + coo + " has no java file");
                return;
            }
            file = Header.getSrcHeader(file);
            lico.setHeaderTxt(file);
            if (!file.isEmpty()) {
                new LicenseWriter().write(coo, "src-header", file);
            }
        }
        catch (IOException e) {
            this.log.warn((CharSequence)NonnullCheck._orElseGet((Object)e.getMessage(), (Object)"pattern problem"));
        }
    }

    public void getPomHeader(Coordinates coordinates, Coordinates2License.LiCo liCo) {
        Path src = this.mlo.getPom(coordinates);
        if (!Files.exists(src, new LinkOption[0])) {
            this.log.warn("no pom available for " + coordinates + " at " + src);
            return;
        }
        String header = Header.getPomHeader(Strings.newString((byte[])Filess.readAllBytes((Path)src)));
        liCo.setPomHeader(header);
        if (!header.isEmpty()) {
            new LicenseWriter().write(coordinates, "pom-header", header);
        }
    }
}

