/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle;

import de.pfabulist.kleinod.nio.IO;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.roast.unchecked.Unchecked;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Utils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(String res) {
        byte[] buf = new byte[3000000];
        int got = 0;
        try (InputStream in = JSONStartup.class.getResourceAsStream(res);){
            if (in == null) {
                String string = "";
                return string;
            }
            while (true) {
                int once;
                if ((once = in.read(buf, got, 3000000 - got)) < 0) {
                    return new String(buf, 0, got, StandardCharsets.UTF_8);
                }
                got += once;
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String unzipToString(InputStream is, Pattern pat) {
        try (ZipInputStream zin = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                if (pat.matcher(ze.getName()).matches()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IO.copy((InputStream)zin, (OutputStream)out);
                    String string = Strings.newString((byte[])out.toByteArray());
                    return string;
                }
                zin.closeEntry();
            }
            return "";
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }
}

