/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.loracle.license.Coordinates;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;

public class MavenLicenseOracle {
    private final Log log;
    private final Path localRepo;

    public MavenLicenseOracle(Log log, Path localRepo) {
        this.log = log;
        this.localRepo = localRepo;
    }

    public Optional<License> getMavenLicense(Artifact arti) {
        Coordinates coo = Coordinates.valueOf(arti);
        try {
            while (true) {
                Path pom;
                String content;
                Optional<String> ret;
                if ((ret = this.extractLicenseName(content = Strings.newString((byte[])Files.readAllBytes(pom = this.getPom(coo))))).isPresent()) {
                    License license = new License();
                    license.setName(ret.get());
                    this.extractUrl(content).ifPresent(arg_0 -> ((License)license).setUrl(arg_0));
                    return Optional.of(license);
                }
                this.log.debug((CharSequence)("       " + coo + " has no license declaration checking parent "));
                Optional<Coordinates> parentCoo = this.extractParentCoords(content);
                if (!parentCoo.isPresent()) break;
                coo = parentCoo.get();
                this.log.debug((CharSequence)("          parent is" + coo));
            }
            this.log.debug((CharSequence)"          no parent");
            return Optional.empty();
        }
        catch (IOException e) {
            this.log.warn((CharSequence)"no pom ?");
            return Optional.empty();
        }
    }

    private Path getPom(Coordinates coords) {
        Path ret = this.localRepo;
        ret = ret.resolve(coords.getGroupId().replace('.', '/'));
        ret = ret.resolve(coords.getArtifactId());
        ret = ret.resolve(coords.getVersion());
        ret = ret.resolve(coords.getArtifactId() + "-" + coords.getVersion() + ".pom");
        return ret;
    }

    Optional<String> extractLicenseName(String raw) {
        String licenseTagStart = "<license>";
        String licenseTagStop = "</license>";
        String nameTagStart = "<name>";
        String nameTagStop = "</name>";
        if (raw.contains("<license>")) {
            String licenseContents = raw.substring(raw.indexOf("<license>") + "<license>".length(), raw.indexOf("</license>"));
            String name = licenseContents.substring(licenseContents.indexOf("<name>") + "<name>".length(), licenseContents.indexOf("</name>"));
            return Optional.of(name);
        }
        return Optional.empty();
    }

    private Optional<String> extractUrl(String raw) {
        String licenseTagStart = "<license>";
        String licenseTagStop = "</license>";
        String nameTagStart = "<url>";
        String nameTagStop = "</url>";
        if (raw.contains("<license>")) {
            String licenseContents = raw.substring(raw.indexOf("<license>") + "<license>".length(), raw.indexOf("</license>"));
            if (!licenseContents.contains("<url>")) {
                return Optional.empty();
            }
            String name = licenseContents.substring(licenseContents.indexOf("<url>") + "<url>".length(), licenseContents.indexOf("</url>"));
            return Optional.of(name);
        }
        return Optional.empty();
    }

    Optional<Coordinates> extractParentCoords(String raw) {
        String parentTagStart = "<parent>";
        String parentTagStop = "</parent>";
        String groupTagStart = "<groupId>";
        String groupTagStop = "</groupId>";
        String artifactTagStart = "<artifactId>";
        String artifactTagStop = "</artifactId>";
        String versionTagStart = "<version>";
        String versionTagStop = "</version>";
        if (!raw.contains("<parent>")) {
            return Optional.empty();
        }
        String contents = raw.substring(raw.indexOf("<parent>") + "<parent>".length(), raw.indexOf("</parent>"));
        String group = contents.substring(contents.indexOf("<groupId>") + "<groupId>".length(), contents.indexOf("</groupId>"));
        String artifact = contents.substring(contents.indexOf("<artifactId>") + "<artifactId>".length(), contents.indexOf("</artifactId>"));
        String version = contents.substring(contents.indexOf("<version>") + "<version>".length(), contents.indexOf("</version>"));
        return Optional.of(new Coordinates(group, artifact, version));
    }
}

