/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.AliasBuilder;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.FuzzyParser;
import de.pfabulist.loracle.license.LicenseExclude;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import de.pfabulist.unchecked.NullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public class LOracle {
    private static Pattern urlPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"http://"), Frex.txt((String)"https://")}).zeroOrOnce().then((Frex)Frex.txt((String)"www.").zeroOrOnce()).then(Frex.any().oneOrMore().lazy().var("relevant")).then((Frex)Frex.txt((String)".").then((Frex)Frex.alpha().oneOrMore()).zeroOrOnce()).buildCaseInsensitivePattern();
    private Map<String, More> singles = new HashMap<String, More>();
    private Map<String, Boolean> licenseExceptions = new HashMap<String, Boolean>();
    private Map<String, More> composites = new HashMap<String, More>();
    private final transient Map<String, Set<LicenseID>> couldbeNames = new HashMap<String, Set<LicenseID>>();
    private final transient Map<String, Set<LicenseID>> couldbeUrls = new HashMap<String, Set<LicenseID>>();
    private final transient SPDXParser parser;
    private final transient AliasBuilder aliasBuilder = new AliasBuilder();
    private transient Map<Coordinates, LicenseID> coordinatesMap = new HashMap<Coordinates, LicenseID>();
    private transient Map<String, LicenseID> longNameMapper = new HashMap<String, LicenseID>();
    private transient Map<String, LicenseID> urls = new HashMap<String, LicenseID>();
    private static Pattern withVersion = Frex.any().oneOrMore().lazy().var("base").then((Frex)Frex.txt((char)' ')).then((Frex)Frex.or((Frex[])new Frex[]{Frex.number(), Frex.txt((char)'.')}).oneOrMore()).buildCaseInsensitivePattern();

    public LOracle() {
        this.parser = new SPDXParser(this);
    }

    public LOracle spread() {
        if (!this.longNameMapper.isEmpty()) {
            throw new IllegalStateException("can only be called after json construction");
        }
        this.singles.entrySet().stream().forEach(e -> {
            String name = (String)NonnullCheck._nn(e.getKey());
            More more = (More)NonnullCheck._nn(e.getValue());
            SingleLicense lid = new SingleLicense(name);
            more.urls.stream().forEach(u -> this.urls.put((String)u, lid));
            more.longNames.stream().forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.stream().forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
            more.couldbeName.stream().forEach(n -> {
                this.couldbeNames.putIfAbsent((String)n, new HashSet());
                this.couldbeNames.get(n).add(lid);
            });
            more.couldbeUrl.stream().forEach(n -> {
                this.couldbeUrls.putIfAbsent((String)n, new HashSet());
                this.couldbeUrls.get(n).add(lid);
            });
        });
        this.composites.entrySet().stream().forEach(e -> {
            String name = (String)NonnullCheck._nn(e.getKey());
            More more = (More)NonnullCheck._nn(e.getValue());
            LicenseID lid = this.getOrThrowByName(name);
            more.urls.stream().forEach(u -> this.urls.put((String)u, lid));
            more.longNames.stream().forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.stream().forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
            more.couldbeName.stream().forEach(n -> {
                this.couldbeNames.putIfAbsent((String)n, new HashSet());
                this.couldbeNames.get(n).add(lid);
            });
            more.couldbeUrl.stream().forEach(n -> {
                this.couldbeUrls.putIfAbsent((String)n, new HashSet());
                this.couldbeUrls.get(n).add(lid);
            });
        });
        return this;
    }

    public LicenseID getOrLater(SingleLicense license, boolean orLater, Optional<LicenseExclude> exception) {
        if (!orLater && !exception.isPresent()) {
            return license;
        }
        ModifiedSingleLicense ret = new ModifiedSingleLicense(license, orLater, exception);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    public LicenseExclude getExceptionOrThrow(String ex) {
        String lower = ex.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            return new LicenseExclude(lower);
        }
        throw new IllegalArgumentException("no such exception: " + ex);
    }

    public static String trim(String in) {
        return ((String)NonnullCheck._nn((Object)in.toLowerCase(Locale.US))).replaceAll(",", " ").trim();
    }

    public SingleLicense newSingle(String name, boolean spdx) {
        String lower = LOracle.trim(name);
        if (this.getByName(lower).isPresent()) {
            throw new IllegalArgumentException("not a new single license: " + name);
        }
        Set<LicenseID> guesses = this.guessByName(lower);
        if (!guesses.isEmpty()) {
            this.removeNameGuess(lower);
        }
        this.singles.put(lower, new More(spdx));
        SingleLicense ret = new SingleLicense(lower);
        String lng = Arrays.stream(lower.split("[- ]")).collect(Collectors.joining(" "));
        this.addLongName(ret, lng);
        return ret;
    }

    private void removeNameGuess(String name) {
        Log.warn((String)("removing could be (so that it can be a new single id) " + name));
        Set<LicenseID> guesses = this.guessByName(name);
        this.couldbeNames.remove(name);
        guesses.stream().forEach(l -> this.getMore((LicenseID)l).couldbeName.remove(name));
    }

    public More getMore(LicenseID licenseID) {
        return (More)NullCheck._orElseGet((Object)this.singles.get(licenseID.getId()), () -> (More)NullCheck._orElseThrow((Object)this.composites.get(licenseID.getId()), () -> new IllegalArgumentException("no such license: " + licenseID)));
    }

    public void addLongName(LicenseID license, String longName) {
        String reduced = this.aliasBuilder.reduce(longName);
        if (this.longNameMapper.containsKey(reduced)) {
            if (license.equals(this.longNameMapper.get(reduced))) {
                return;
            }
            throw new IllegalArgumentException("mapped already <" + longName + "> (" + reduced + ") as " + license + " <" + this.longNameMapper.get(reduced) + ">");
        }
        this.longNameMapper.put(reduced, license);
        this.getMore((LicenseID)license).longNames.add(reduced);
        Matcher versioned = withVersion.matcher(reduced);
        if (versioned.matches()) {
            this.addCouldbeName(license, (String)NonnullCheck._nn((Object)versioned.group("base")));
        }
        if (reduced.contains("gnu")) {
            if (reduced.contains("lesser")) {
                this.addCouldbeName(license, "gnu lesser");
            } else if (reduced.contains("affero")) {
                this.addCouldbeName(license, "affero gnu");
                this.addCouldbeName(license, "affero");
            } else {
                this.addCouldbeName(license, "gnu");
            }
        } else if (reduced.contains("affero")) {
            this.addCouldbeName(license, "affero gnu");
            this.addCouldbeName(license, "affero");
        }
    }

    public Optional<SingleLicense> getSingle(String name) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (!this.singles.containsKey(lower)) {
            return Optional.empty();
        }
        return Optional.of(new SingleLicense(lower));
    }

    public Optional<LicenseID> getByName1(String name) {
        try {
            return Optional.of(this.parser.parse(name));
        }
        catch (Exception exception) {
            return Optional.ofNullable(this.longNameMapper.get(this.aliasBuilder.reduce(name)));
        }
    }

    public Optional<LicenseID> getByName(String name) {
        try {
            return Optional.of(this.parser.parse(name));
        }
        catch (Exception exception) {
            Optional<LicenseID> ret = Optional.ofNullable(this.longNameMapper.get(this.aliasBuilder.reduce(name)));
            if (ret.isPresent()) {
                return ret;
            }
            try {
                return Optional.of(new FuzzyParser(this).parse(name));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }

    public LicenseID getOrThrowByName(String name) {
        return this.getByName(name).orElseThrow(() -> new IllegalArgumentException("no such license name: " + name));
    }

    public void addLicenseForArtifact(Coordinates coo, LicenseID licenseID) {
        this.getMore((LicenseID)licenseID).specific.add(coo);
        this.coordinatesMap.put(coo, licenseID);
    }

    public Optional<LicenseID> getByCoordinates(Coordinates coo) {
        return Optional.ofNullable(this.coordinatesMap.get(coo));
    }

    public void addException(String name, boolean spdx) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            throw new IllegalArgumentException("existing exception: " + lower);
        }
        this.licenseExceptions.put(lower, spdx);
    }

    public Optional<LicenseID> getByUrl(String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String rel = ((String)NonnullCheck._nn((Object)matcher.group("relevant"))).toLowerCase(Locale.US);
        return Optional.ofNullable(this.urls.get(rel));
    }

    public void setOsiApproval(LicenseID licenseID, boolean osiApproved) {
        this.getMore((LicenseID)licenseID).osiApproved = osiApproved;
    }

    public CompositeLicense getAnd(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(false, left, right);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    public CompositeLicense getOr(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(true, left, right);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    public void addCouldbeName(LicenseID license, String couldbe) {
        this.getByName(couldbe).ifPresent(l -> new IllegalArgumentException("name is already set to definitive license: " + couldbe + " -> " + l));
        this.getMore((LicenseID)license).couldbeName.add(couldbe);
        this.couldbeNames.putIfAbsent(couldbe, new HashSet());
        this.couldbeNames.get(couldbe).add(license);
    }

    public Set<LicenseID> guessByName(String name) {
        return Optional.ofNullable(this.couldbeNames.get(this.aliasBuilder.reduce(name))).orElseGet(Collections::emptySet);
    }

    public void addUrl(LicenseID license, String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not a url: " + url);
        }
        String rel = ((String)NonnullCheck._nn((Object)matcher.group("relevant"))).toLowerCase(Locale.US);
        if (this.urls.containsKey(rel)) {
            LicenseID old = (LicenseID)NonnullCheck._nn((Object)this.urls.get(rel));
            if (old.equals(license)) {
                return;
            }
            Log.info((String)("known url: " + url + " as: " + old + "  moving it to couldbe, together with " + license));
            this.urls.remove(rel);
            this.getMore((LicenseID)license).couldbeName.add(license.toString());
            this.couldbeUrls.putIfAbsent(rel, new HashSet());
            this.couldbeUrls.get(rel).add(license);
            this.couldbeUrls.get(rel).add(old);
            this.getMore((LicenseID)license).urls.add(rel);
            return;
        }
        if (this.couldbeUrls.containsKey(rel)) {
            this.couldbeUrls.get(rel).add(license);
            this.getMore((LicenseID)license).urls.add(rel);
            Log.info((String)("known couldbe url: " + url + " for " + license));
            return;
        }
        this.getMore((LicenseID)license).urls.add(rel);
        this.urls.put(rel, license);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class More {
        public boolean spdx;
        public boolean osiApproved;
        public Optional<Boolean> fedoraApproved = Optional.empty();
        public Optional<Boolean> gpl2Compatible = Optional.empty();
        public Optional<Boolean> gpl3Compatible = Optional.empty();
        public List<String> urls = new ArrayList<String>();
        public List<String> longNames = new ArrayList<String>();
        public List<Coordinates> specific = new ArrayList<Coordinates>();
        public Set<String> couldbeName = new HashSet<String>();
        public Set<String> couldbeUrl = new HashSet<String>();

        public More(boolean spdx) {
            this.spdx = spdx;
        }
    }
}

