/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.LicenseIDs;
import java.util.Optional;
import org.apache.maven.plugin.logging.Log;

public class Decider {
    private final Log log;

    public Decider(Log log) {
        this.log = log;
    }

    public Optional<LicenseID> decide(Optional<LicenseID> byCoordinates, Optional<LicenseID> byName, Optional<LicenseID> byUrl) {
        if (byCoordinates.isPresent()) {
            return Optional.of(this.decideWithCoordinates(byCoordinates.get(), byName, byUrl));
        }
        if (byName.isPresent()) {
            return this.decideWithName(byName.get(), byUrl);
        }
        byUrl.ifPresent(this::warnOnAnd);
        return byUrl;
    }

    private Optional<LicenseID> decideWithName(LicenseID licenseID, Optional<LicenseID> byUrl) {
        byUrl.ifPresent(name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by url differs " + name));
            }
        });
        this.warnOnAnd(licenseID);
        return Optional.of(licenseID);
    }

    private LicenseID decideWithCoordinates(LicenseID licenseID, Optional<LicenseID> byName, Optional<LicenseID> byUrl) {
        byName.ifPresent(name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by name differs " + name));
            }
        });
        byUrl.ifPresent(name -> {
            if (!name.equals(licenseID)) {
                this.log.warn((CharSequence)("   license by url differs " + name));
            }
        });
        return licenseID;
    }

    private void warnOnAnd(LicenseID licenseID) {
        if (LicenseIDs.isAnd(licenseID)) {
            this.log.error((CharSequence)("   fulfilling the constraints of 2 license is unlikely, was 'or' meant? or really " + licenseID));
            this.log.error((CharSequence)"   set it directly in plugin configuration");
        }
    }
}

