/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.mojo;

import de.pfabulist.loracle.buildup.JSONStartup;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.LOracle;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.mojo.Findings;
import de.pfabulist.loracle.mojo.LicenseDeclaration;
import de.pfabulist.loracle.mojo.MavenLicenseOracle;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

@Mojo(name="license-check", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class LOracleMojo
extends AbstractMojo {
    @Nullable
    @Component
    DependencyGraphBuilder dependencyGraphBuilder;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Nullable
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Nullable
    @Parameter(property="license-check.ikwid")
    List<LicenseDeclaration> licenseDeclarations;

    public DependencyGraphBuilder getDependencyGraphBuilder() {
        return (DependencyGraphBuilder)NonnullCheck._ni((Object)this.dependencyGraphBuilder);
    }

    public MavenProject getProject() {
        return (MavenProject)NonnullCheck._ni((Object)this.project);
    }

    public MavenSession getSession() {
        return (MavenSession)NonnullCheck._ni((Object)this.session);
    }

    public List<LicenseDeclaration> getLicenseDeclarations() {
        return this.licenseDeclarations == null ? Collections.emptyList() : this.licenseDeclarations;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"---------------------------------------");
        this.getLog().info((CharSequence)"      loracle license check                    ");
        this.getLog().info((CharSequence)"---------------------------------------");
        Path localRepo = Paths.get(((ArtifactRepository)NonnullCheck._nn((Object)this.getSession().getLocalRepository())).getBasedir(), new String[0]);
        try {
            if (this.getProject().getLicenses() == null || this.getProject().getLicenses().isEmpty()) {
                throw new MojoFailureException("no license set");
            }
            if (this.getProject().getLicenses().size() > 1) {
                this.getLog().info((CharSequence)"license check can't deal with multiple licenses (yet)");
                return;
            }
            Findings failures = new Findings(this.getLog());
            LOracle lOracle = JSONStartup.start().spread();
            for (LicenseDeclaration excl : this.getLicenseDeclarations()) {
                Coordinates coo = Coordinates.valueOf(excl.getCoordinates().orElseThrow(() -> new MojoFailureException("no coordinates set in configuration of LicenseDeclarations in LOracle Plugin")));
                LicenseID license = lOracle.getByName(excl.getLicense().orElseThrow(() -> new MojoFailureException("no name set in configuration of LicenseDeclarations in LOracle Plugin"))).orElseThrow(() -> new MojoFailureException("illegal license name in configuration of LicenseDeclarations in LOracle Plugin"));
                lOracle.addLicenseForArtifact(coo, license);
            }
            MavenLicenseOracle mlo = new MavenLicenseOracle(failures, localRepo);
            ArtifactFilter artifactFilter = this.createResolvingArtifactFilter();
            DependencyNode rootNode = (DependencyNode)NonnullCheck._nn((Object)this.getDependencyGraphBuilder().buildDependencyGraph(this.project, artifactFilter));
            final ArrayList dependencies = new ArrayList();
            rootNode.accept(new DependencyNodeVisitor(){

                public boolean visit(DependencyNode dependencyNode) {
                    dependencies.add(dependencyNode.getArtifact());
                    return true;
                }

                public boolean endVisit(DependencyNode dependencyNode) {
                    return true;
                }
            });
            dependencies.stream().forEach(a -> this.licenseMapping(failures, lOracle, mlo, (Artifact)a));
            failures.throwOnError();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException(e.getMessage());
        }
    }

    private Optional<LicenseID> licenseMapping(Findings findings, LOracle lOracle, MavenLicenseOracle mlo, Artifact a) {
        Optional<License> mavenLicense = mlo.getMavenLicense(a);
        Coordinates coo = Coordinates.valueOf(a);
        Optional<LicenseID> byCoordinates = lOracle.getByCoordinates(Coordinates.valueOf(a));
        Optional name = mavenLicense.flatMap(l -> Optional.ofNullable(l.getName()));
        Optional<String> byName = name.flatMap(lOracle::getByName);
        Optional url = mavenLicense.flatMap(l -> Optional.ofNullable(l.getUrl()));
        Optional<String> byUrl = url.flatMap(lOracle::getByUrl);
        try {
            LicenseID sum = byCoordinates.orElseGet(() -> byName.orElseGet(() -> (LicenseID)byUrl.orElseThrow(() -> new IllegalArgumentException("no license for:" + coo))));
            this.getLog().info((CharSequence)(this.artiPlus(a) + sum));
            return Optional.of(sum);
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((CharSequence)("artifact: " + coo + "   has no or not precise enough license"));
            this.getLog().error((CharSequence)("    by coordinates : " + byCoordinates.map(Object::toString).orElse("-")));
            this.getLog().error((CharSequence)("    by license name: " + name.orElse("-") + " -> " + byName.map(Object::toString).orElse("-")));
            this.getLog().error((CharSequence)("    by license url : " + url.orElse("-") + " ->" + byUrl.map(Object::toString).orElse("-")));
            findings.error("artifact: " + coo + "   has no or not precise enough license");
            return Optional.empty();
        }
    }

    String artiPlus(Artifact coo) {
        StringBuilder sb = new StringBuilder().append(coo.toString());
        for (int i = coo.toString().length(); i < 80; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private ArtifactFilter createResolvingArtifactFilter() {
        return new ScopeArtifactFilter("test");
    }
}

