/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.frex.Frex;
import de.pfabulist.loracle.license.AliasBuilder;
import de.pfabulist.loracle.license.CompositeLicense;
import de.pfabulist.loracle.license.Coordinates;
import de.pfabulist.loracle.license.LicenseExclude;
import de.pfabulist.loracle.license.LicenseID;
import de.pfabulist.loracle.license.ModifiedSingleLicense;
import de.pfabulist.loracle.license.SPDXParser;
import de.pfabulist.loracle.license.SingleLicense;
import de.pfabulist.nonnullbydefault.NonnullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public class LOracle {
    private static Pattern urlPattern = Frex.or((Frex[])new Frex[]{Frex.txt((String)"http://"), Frex.txt((String)"https://")}).zeroOrOnce().then((Frex)Frex.txt((String)"www.").zeroOrOnce()).then(Frex.any().oneOrMore().lazy().var("relevant")).then((Frex)Frex.txt((String)".").then((Frex)Frex.alpha().oneOrMore()).zeroOrOnce()).buildCaseInsensitivePattern();
    private final transient SPDXParser parser;
    private final transient AliasBuilder aliasBuilder = new AliasBuilder();
    private Map<String, More> singles = new HashMap<String, More>();
    private transient Map<Coordinates, LicenseID> coordinatesMap = new HashMap<Coordinates, LicenseID>();
    private transient Map<String, LicenseID> longNameMapper = new HashMap<String, LicenseID>();
    private Map<String, Boolean> licenseExceptions = new HashMap<String, Boolean>();
    private transient Map<String, LicenseID> urls = new HashMap<String, LicenseID>();
    private Map<String, More> composites = new HashMap<String, More>();

    public LOracle() {
        this.parser = new SPDXParser(this);
    }

    public LOracle spread() {
        if (!this.longNameMapper.isEmpty()) {
            throw new IllegalStateException("can only be called after json construction");
        }
        this.singles.entrySet().stream().forEach(e -> {
            String name = (String)NonnullCheck._nn(e.getKey());
            More more = (More)NonnullCheck._nn(e.getValue());
            SingleLicense lid = new SingleLicense(name);
            more.urls.stream().forEach(u -> this.urls.put((String)u, lid));
            more.longNames.stream().forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.stream().forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
        });
        this.composites.entrySet().stream().forEach(e -> {
            String name = (String)NonnullCheck._nn(e.getKey());
            More more = (More)NonnullCheck._nn(e.getValue());
            LicenseID lid = this.getOrThrowByName(name);
            more.urls.stream().forEach(u -> this.urls.put((String)u, lid));
            more.longNames.stream().forEach(l -> this.longNameMapper.putIfAbsent((String)l, lid));
            more.specific.stream().forEach(coo -> this.coordinatesMap.putIfAbsent((Coordinates)coo, lid));
        });
        return this;
    }

    public LicenseID getOrLater(SingleLicense license, boolean orLater, Optional<LicenseExclude> exception) {
        if (!orLater && !exception.isPresent()) {
            return license;
        }
        ModifiedSingleLicense ret = new ModifiedSingleLicense(license, orLater, exception);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    public LicenseExclude getExceptionOrThrow(String ex) {
        String lower = ex.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            return new LicenseExclude(lower);
        }
        throw new IllegalArgumentException("no such exception: " + ex);
    }

    public SingleLicense newSingle(String name, boolean spdx) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (this.singles.containsKey(lower)) {
            throw new IllegalArgumentException("no a new single license: " + name);
        }
        this.singles.put(lower, new More(true));
        return new SingleLicense(lower);
    }

    public More getMore(LicenseID licenseID) {
        More ret = this.singles.get(licenseID.getId());
        if (ret != null) {
            return ret;
        }
        ret = this.composites.get(licenseID.getId());
        if (ret != null) {
            return ret;
        }
        throw new IllegalArgumentException("no such license: " + licenseID);
    }

    public void addLongName(LicenseID license, String longName) {
        String reduced = this.aliasBuilder.reduce(longName);
        if (this.longNameMapper.containsKey(reduced)) {
            throw new IllegalArgumentException("mapped already " + longName + " (" + reduced + ") " + license + " " + this.longNameMapper.get(reduced));
        }
        this.longNameMapper.put(reduced, license);
        this.getMore((LicenseID)license).longNames.add(reduced);
    }

    public Optional<SingleLicense> getSingle(String name) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (!this.singles.containsKey(lower)) {
            return Optional.empty();
        }
        return Optional.of(new SingleLicense(lower));
    }

    public Optional<LicenseID> getByName(String name) {
        try {
            return Optional.of(this.parser.parse(name));
        }
        catch (Exception exception) {
            return Optional.ofNullable(this.longNameMapper.get(this.aliasBuilder.reduce(name)));
        }
    }

    public LicenseID getOrThrowByName(String name) {
        return this.getByName(name).orElseThrow(() -> new IllegalArgumentException("no such license name: " + name));
    }

    public void addLicenseForArtifact(Coordinates coo, LicenseID licenseID) {
        this.getMore((LicenseID)licenseID).specific.add(coo);
        this.coordinatesMap.put(coo, licenseID);
    }

    public Optional<LicenseID> getByCoordinates(Coordinates coo) {
        return Optional.ofNullable(this.coordinatesMap.get(coo));
    }

    public void addException(String name, boolean spdx) {
        String lower = name.trim().toLowerCase(Locale.US);
        if (this.licenseExceptions.containsKey(lower)) {
            throw new IllegalArgumentException("existing exception: " + lower);
        }
        this.licenseExceptions.put(lower, spdx);
    }

    public void addUrl(LicenseID license, String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("not a url: " + url);
        }
        String rel = ((String)NonnullCheck._nn((Object)matcher.group("relevant"))).toLowerCase(Locale.US);
        if (this.urls.containsKey(rel)) {
            if (((LicenseID)NonnullCheck._nn((Object)this.urls.get(rel))).equals(license)) {
                return;
            }
            throw new IllegalArgumentException("known url: " + url);
        }
        this.getMore((LicenseID)license).urls.add(rel);
        this.urls.put(rel, license);
    }

    public Optional<LicenseID> getByUrl(String url) {
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String rel = ((String)NonnullCheck._nn((Object)matcher.group("relevant"))).toLowerCase(Locale.US);
        return Optional.ofNullable(this.urls.get(rel));
    }

    public void setOsiApproval(LicenseID licenseID, boolean osiApproved) {
        this.getMore((LicenseID)licenseID).osiApproved = osiApproved;
    }

    public CompositeLicense getAnd(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(false, left, right);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    public CompositeLicense getOr(LicenseID left, LicenseID right) {
        CompositeLicense ret = new CompositeLicense(true, left, right);
        this.composites.putIfAbsent(ret.getId(), new More(false));
        return ret;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    private static class More {
        public boolean spdx;
        public boolean osiApproved;
        public List<String> urls = new ArrayList<String>();
        public List<String> longNames = new ArrayList<String>();
        public List<Coordinates> specific = new ArrayList<Coordinates>();

        public More(boolean spdx) {
            this.spdx = spdx;
        }
    }
}

