/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.loracle.license;

import de.pfabulist.nonnullbydefault.NonnullCheck;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;

public class Coordinates {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public Coordinates(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            throw new IllegalArgumentException("not a legal coordinates, one of group, artifact, version is empty");
        }
    }

    public static Coordinates valueOf(String str) {
        String[] parts = str.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("not legal coordinates group:arti:version, got: " + str);
        }
        return new Coordinates((String)NonnullCheck._nn((Object)parts[0]), (String)NonnullCheck._nn((Object)parts[1]), (String)NonnullCheck._nn((Object)parts[2]));
    }

    public static Coordinates valueOf(Artifact arti) {
        return new Coordinates((String)NonnullCheck._nn((Object)arti.getGroupId()), (String)NonnullCheck._nn((Object)arti.getArtifactId()), (String)NonnullCheck._nn((Object)arti.getVersion()));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Coordinates)) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId + ':' + this.version;
    }
}

