package de.pfabulist.lisplight;

import java.util.ArrayList;
import java.util.List;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Ray implements Stream, Lbd {

    @Override
    public Thing exec( List<Thing> res ) {
        if( res.size() != 1 || !((res.get(0) instanceof Number ))) {
            return new Exc( "a ray needs a Number arg" );
        }
        return get( ((Number)res.get(0)).bi.intValueExact() );
    }

    @Override
    public int getArgumentCount() {
        return 1;
    }

    private static class RayBlock {
        public List<Thing> preStream = new ArrayList<>();
        public int streamIdx = -1;
        public Lazy cmd;
        public Lbd todo;

        public void add( Thing current ) {
            preStream.add( current );
        }

        public int size() {
            if( streamIdx >= 0 ) {
                return streamIdx;
            }
            return preStream.size();
        }
    }

    private List<RayBlock> blocks = new ArrayList<>();
    private Stream startStream;
    private Env env;

    public Ray( Env env, List<Thing> args ) {
        this.env = env;

        Thing prest = args.get( 0 ).eval( env );

        if( !( prest instanceof Ray || prest instanceof Lbd || prest instanceof Lst) ) {
            throw new IllegalStateException( "ray missing, got: " + prest );
        }

        blocks.add( new RayBlock() );
        blocks.get(0).streamIdx = 0;

        startStream = prest instanceof Stream ? (Stream) prest : new LazyStream( env, (Lbd) prest );

        for( int idx = 1; idx < args.size(); idx++ ) {
            RayBlock nextBlock = new RayBlock();
            //nextBlock.preStream = commands.n( new ArrayList<>());

            if( !( args.get( idx ) instanceof Lst ) ) {
                throw new IllegalStateException( "ray: not a Lst: " + args.get( idx ) );
            }

            Lst cmd = (Lst) args.get( idx );
            if( cmd.size() != 2 || !( cmd.get( 0 ) instanceof Lazy ) ) {
                throw new IllegalStateException( "just commands cmds not: " + args.get( idx ) );
            }

            nextBlock.cmd = (Lazy) cmd.get( 0 );
            nextBlock.todo = (Lbd) cmd.get( 1 ).eval( env );    // todo more checks

            blocks.add( nextBlock );

        }

    }

    @Override
    public Thing get( int target ) {
        // run it
        boolean streamRunning = true;

        for( ;//blocks.get(0).streamIdx = 0;
             streamRunning && blocks.get( blocks.size() - 1 ).preStream.size() <= target && startStream.has( blocks.get( 0 ).streamIdx );
             blocks.get( 0 ).streamIdx++ ) {

            boolean cmdRunning = true;
            Thing current = startStream.get( blocks.get( 0 ).streamIdx );

            for( int idx = 1; idx < blocks.size() && cmdRunning; idx++ ) {

                RayBlock oldBlock = blocks.get( idx - 1 );
                RayBlock nowBlock = blocks.get( idx );
                Thing cmdRes = executeCmd( env, nowBlock.todo, current, nowBlock.size(), nowBlock.preStream, oldBlock.size() );

                switch( nowBlock.cmd.toString() ) {
                    case ":filter": {
                        Bool takep = (Bool) cmdRes;
                        if( takep.is() ) {
                            nowBlock.add( current );
                        } else {
                            cmdRunning = false;
                        }
                        break;
                    }
                    case ":while": {

                        Bool takep = (Bool) cmdRes;
                        if( !takep.is() ) {
                            // get next from preStream, and all follow
                            streamRunning = false;
                        } else {
                            nowBlock.add( current );
                        }
                        break;

                    }
                    case ":map": {
                        nowBlock.add( cmdRes );
                        current = cmdRes;
                        break;

                    }
                    case ":find": {
                        if( ( (Bool) cmdRes ).is() ) {
                            nowBlock.add( current );
                            streamRunning = false;
                        }
                        cmdRunning = false;
                        break;
                    }

                    default:
                        throw new IllegalStateException( "no " + nowBlock.cmd );
                }
            }
        }

        if( blocks.size() == 1 ) {
            throw new IllegalStateException( "not yet" );
        }

        if( target < blocks.get( blocks.size() - 1 ).preStream.size() ) {
            return blocks.get( blocks.size() - 1 ).preStream.get( target );
        }

        return new Exc( "no idx" );

    }

    @Override
    public boolean has( int stridx ) {
        return !(get( stridx ) instanceof Exc); // no collection of exc possible
    }

//    @Override
//    public Thing exec( List<Thing> res ) {
//        return null;
//    }

//    @Override
//    public int getArgumentCount() {
//        return 1;
//    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }

    @Override
    public String toString() {
        return "Ray{}";
    }

    private boolean isBar( Lbd lbd, int idx ) {
        return lbd instanceof Lambda &&
                !( (Lambda) lbd ).isUsed( idx );
    }

    private Thing executeCmd( Env env, Lbd lbd, Thing streamElement, int stridx, List<Thing> prestream,
                              int beforeSize ) {

        switch( lbd.getArgumentCount() ) {
            case 0:
                throw new IllegalStateException( "when" );
            case 1: {
                List<Thing> args = new ArrayList<>();
                args.add( streamElement );

                return lbd.exec( args );
            }
            case 2: {
                List<Thing> args = new ArrayList<>();
                args.add( streamElement );
                args.add( Number.n( "" + stridx ) );

                return lbd.exec( args );
            }
            case 3: {
                List<Thing> args = new ArrayList<>();
                args.add( streamElement );
                args.add( Number.n( "" + stridx ) );
                if( isBar( lbd, 2 ) ) {
                    args.add( Null.n() ); // exc ?
                } else {
                    args.add( Lst.n( new ArrayList<>( prestream ) ) );
                }
                return lbd.exec( args );
            }
            case 4: {
                List<Thing> args = new ArrayList<>();
                args.add( streamElement );
                args.add( Number.n( "" + stridx ) );
                if( isBar( lbd, 2 ) ) {
                    args.add( Null.n() ); // exc ?
                } else {
                    args.add( Lst.n( new ArrayList<>( prestream ) ) );
                }
                if( isBar( lbd, 3 ) ) {
                    args.add( Null.n() ); // exc ?
                } else {
                    args.add( Number.n( "" + beforeSize ) );
                }
                return lbd.exec( args );
            }
            default:
                throw new IllegalStateException( "no before yet: " + lbd );

        }

    }
}
