package de.pfabulist.lisplight;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class NumberLambda implements Lbd {

    private final String name;

    public NumberLambda( String name ) {
        this.name = name;
    }

    static public void addLambdas( Map<String,Thing> map ) {
        map.put( "+", new NumberLambda( "+" ) );
        map.put( "-", new NumberLambda( "-" ) );
        map.put( "remainder", new NumberLambda( "remainder" ) );
        map.put( ">", new NumberLambda( ">" ) );
        map.put( "<", new NumberLambda( "<" ) );
        map.put( "<=", new NumberLambda( "<=" ) );
        map.put( "*", new NumberLambda( "*" ) );
    }

    @Override
    public Thing exec( List<Thing> res ) {
        switch( name ) {
            case "+":
                return n( res, 0 ).plus( n( res, 1 ) );
            case "*":
                return n( res, 0 ).times( n( res, 1 ) );
            case "-":
                return n( res, 0 ).minus( n( res, 1 ) );
            case ">":
                return n( res, 0 ).greater( n( res, 1 ) );
            case "<":
                return n( res, 1 ).greater( n( res, 0 ) ); // on purpose
            case "<=":
                return new Bool( n( res, 0 ).compareTo( n( res, 1 ) ) < 1 ); // on purpose
            case "remainder":
                return n( res, 0 ).remainder( n( res, 1 ) );

                default:

            throw new IllegalStateException( "unknown ldb" + name );
        }
    }

    public Number n( List<Thing> res, int idx  ) {
        if ( res.size() <= idx ) {
            throw new IllegalStateException( "need more arguments: " + name + ", " + idx );
        }

        Thing ret = res.get( idx );

        if ( ret instanceof Number ) {
            return (Number) ret;
        }

        throw new IllegalStateException( "not a number arguments: " + name + ", " + ret );

    }

    @Override
    public int getArgumentCount() {
        return 2;  // later switch
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }
}
