package de.pfabulist.lisplight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LazyHome implements Lazy {
    private final String name;

    public LazyHome( String name ) {
        this.name = name;
    }
    public static LazyHome n( String name ) {
        return new LazyHome( name );
    }

    @Override
    public Thing exec( Env env, List<Thing> args ) {
        switch( name ) {
            case "!if" : {
                Thing is = args.get( 0 ).eval( env );
                if( is instanceof Bool ) {
                    if( ( (Bool) is ).is() ) {
                        return args.get( 1 ).eval( env );
                    }
                    return args.get( 2 ).eval( env );
                }

                throw new IllegalStateException( "if unbool" );
            }
            case "!lbd" : {
                Thing is = args.get( 0 );
                return new Lambda( env, args.get( 1),
                            ((Lst)is).getInternal().stream().map( e -> e.toString() ).collect( Collectors.toList() ));
            }
            case "!let" : {
                Thing news = args.get( 0 );
                Map<String,Thing> now = new HashMap<>( );
                ((Lst)news).getInternal().forEach( n -> now.put( n.toString(), new Dont() ));

                Env next = env.next( now );

                Thing ret = Null.n();
                for( int i = 1; i<args.size(); i++ ) {
                    ret = args.get( i ).eval( next );
                }

                return ret;
            }
            case "!set" : {
                Symbol name = (Symbol)args.get( 0 );
                Thing res = args.get(1).eval( env );
                env.set( name.toString(), res );
                return res;
            }
            case "!flow" : {
                return new Flow().flow( env, args );
            }
            case "!ray" : {
                try {
                    return new Ray( env, args );
                } catch( Exception e ) {
                    return new Exc( "syntax or semantic error" );
                }
            }

            default:
                    throw new IllegalStateException( "ops" );

        }

    }

    @Override
    public String toString() {
        return name;
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }
}
