/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Bool;
import de.pfabulist.lisplight.Env;
import de.pfabulist.lisplight.Lbd;
import de.pfabulist.lisplight.Number;
import de.pfabulist.lisplight.Thing;
import java.util.List;
import java.util.Map;

public class NumberLambda
implements Lbd {
    private final String name;

    public NumberLambda(String name) {
        this.name = name;
    }

    public static void addLambdas(Map<String, Thing> map) {
        map.put("+", new NumberLambda("+"));
        map.put("-", new NumberLambda("-"));
        map.put("remainder", new NumberLambda("remainder"));
        map.put(">", new NumberLambda(">"));
        map.put("<", new NumberLambda("<"));
        map.put("<=", new NumberLambda("<="));
        map.put("*", new NumberLambda("*"));
    }

    @Override
    public Thing exec(List<Thing> res) {
        switch (this.name) {
            case "+": {
                return this.n(res, 0).plus(this.n(res, 1));
            }
            case "*": {
                return this.n(res, 0).times(this.n(res, 1));
            }
            case "-": {
                return this.n(res, 0).minus(this.n(res, 1));
            }
            case ">": {
                return this.n(res, 0).greater(this.n(res, 1));
            }
            case "<": {
                return this.n(res, 1).greater(this.n(res, 0));
            }
            case "<=": {
                return new Bool(this.n(res, 0).compareTo(this.n(res, 1)) < 1);
            }
            case "remainder": {
                return this.n(res, 0).remainder(this.n(res, 1));
            }
        }
        throw new IllegalStateException("unknown ldb" + this.name);
    }

    public Number n(List<Thing> res, int idx) {
        if (res.size() <= idx) {
            throw new IllegalStateException("need more arguments: " + this.name + ", " + idx);
        }
        Thing ret = res.get(idx);
        if (ret instanceof Number) {
            return (Number)ret;
        }
        throw new IllegalStateException("not a number arguments: " + this.name + ", " + ret);
    }

    @Override
    public int getArgumentCount() {
        return 2;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }
}

