/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Env;
import de.pfabulist.lisplight.Exc;
import de.pfabulist.lisplight.Lbd;
import de.pfabulist.lisplight.Lst;
import de.pfabulist.lisplight.Number;
import de.pfabulist.lisplight.Thing;
import java.util.List;
import java.util.Map;

public class ListLbd
implements Lbd {
    private final String name;

    public ListLbd(String name) {
        this.name = name;
    }

    public static void addLambdas(Map<String, Thing> map) {
        map.put("list", new ListLbd("list"));
        map.put("rget", new ListLbd("rget"));
    }

    @Override
    public Thing exec(List<Thing> res) {
        switch (this.name) {
            case "list": {
                return Lst.n(res);
            }
            case "rget": {
                Lst lst = this.n(res, 0);
                int size = lst.size();
                int idx = ((Number)res.get((int)1)).bi.intValueExact();
                int realIdx = size - 1 - idx;
                if (realIdx >= size || realIdx < 0) {
                    return new Exc("rget bad idx " + idx);
                }
                return lst.get(size - 1 - idx);
            }
        }
        throw new IllegalStateException("unknown ldb" + this.name);
    }

    private Lst n(List<Thing> res, int idx) {
        if (res.size() <= idx) {
            throw new IllegalStateException("need more arguments: " + this.name + ", " + idx);
        }
        Thing ret = res.get(idx);
        if (ret instanceof Lst) {
            return (Lst)ret;
        }
        throw new IllegalStateException("not a number arguments: " + this.name + ", " + ret);
    }

    @Override
    public int getArgumentCount() {
        switch (this.name) {
            case "list": {
                return -1;
            }
            case "rget": {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }
}

