/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Env;
import de.pfabulist.lisplight.Lbd;
import de.pfabulist.lisplight.Thing;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class Lambda
implements Lbd {
    private final List<String> names;
    private final Thing body;
    private final Env env;

    public Lambda(Env env, Thing body, List<String> names) {
        this.names = names;
        this.body = body;
        this.env = env;
    }

    public String toString() {
        return "(!lbd (" + this.names.stream().collect(Collectors.joining(" ")) + ") " + this.body + ")";
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }

    @Override
    public Thing exec(List<Thing> res) {
        HashMap<String, Thing> next = new HashMap<String, Thing>();
        for (int i = 0; i < this.names.size(); ++i) {
            if (this.names.get(i).equals("_")) continue;
            next.put(this.names.get(i), res.get(i));
        }
        Env exectime = this.env.next(next);
        return this.body.eval(exectime);
    }

    @Override
    public int getArgumentCount() {
        return this.names.size();
    }

    public boolean isUsed(int idx) {
        return !this.names.get(idx).equals("_");
    }
}

