/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Bool;
import de.pfabulist.lisplight.Env;
import de.pfabulist.lisplight.Lambda;
import de.pfabulist.lisplight.Lazy;
import de.pfabulist.lisplight.LazyStream;
import de.pfabulist.lisplight.Lbd;
import de.pfabulist.lisplight.Lst;
import de.pfabulist.lisplight.Null;
import de.pfabulist.lisplight.Number;
import de.pfabulist.lisplight.Stream;
import de.pfabulist.lisplight.Thing;
import java.util.ArrayList;
import java.util.List;

public class Flow {
    public Thing flow(Env env, List<Thing> lst) {
        ArrayList<FlowBlock> blocks = new ArrayList<FlowBlock>();
        FlowBlock first = new FlowBlock();
        Thing prest = lst.get(0).eval(env);
        blocks.add(first);
        Stream startStream = prest instanceof Stream ? (Stream)prest : new LazyStream(env, (Lbd)prest);
        for (int idx = 1; idx < lst.size(); ++idx) {
            FlowBlock nextBlock = new FlowBlock();
            if (!(lst.get(idx) instanceof Lst)) {
                throw new IllegalStateException("just lst cmds not: " + lst.get(idx));
            }
            Lst cmd = (Lst)lst.get(idx);
            if (cmd.size() != 2 || !(cmd.get(0) instanceof Lazy)) {
                throw new IllegalStateException("just lst cmds not: " + lst.get(idx));
            }
            nextBlock.cmd = (Lazy)cmd.get(0);
            nextBlock.todo = (Lbd)cmd.get(1).eval(env);
            blocks.add(nextBlock);
        }
        boolean streamRunning = true;
        ((FlowBlock)blocks.get((int)0)).streamIdx = 0;
        while (streamRunning && startStream.has(((FlowBlock)blocks.get((int)0)).streamIdx)) {
            boolean cmdRunning = true;
            Thing current = startStream.get(((FlowBlock)blocks.get((int)0)).streamIdx);
            block14: for (int idx = 1; idx < lst.size() && cmdRunning; ++idx) {
                FlowBlock oldBlock = (FlowBlock)blocks.get(idx - 1);
                FlowBlock nowBlock = (FlowBlock)blocks.get(idx);
                Thing cmdRes = this.executeCmd(env, nowBlock.todo, current, nowBlock.size(), nowBlock.preStream, oldBlock.size());
                switch (nowBlock.cmd.toString()) {
                    case ":filter": {
                        Bool takep = (Bool)cmdRes;
                        if (takep.is()) {
                            nowBlock.add(current);
                            continue block14;
                        }
                        cmdRunning = false;
                        continue block14;
                    }
                    case ":while": {
                        Bool takep = (Bool)cmdRes;
                        if (!takep.is()) {
                            streamRunning = false;
                            continue block14;
                        }
                        nowBlock.add(current);
                        continue block14;
                    }
                    case ":map": {
                        nowBlock.add(cmdRes);
                        current = cmdRes;
                        continue block14;
                    }
                    case ":find": {
                        if (((Bool)cmdRes).is()) {
                            nowBlock.add(current);
                            streamRunning = false;
                        }
                        cmdRunning = false;
                        continue block14;
                    }
                    default: {
                        throw new IllegalStateException("no " + nowBlock.cmd);
                    }
                }
            }
            ++((FlowBlock)blocks.get((int)0)).streamIdx;
        }
        if (lst.size() == 1) {
            throw new IllegalStateException("not yet");
        }
        return Lst.n(((FlowBlock)blocks.get((int)(lst.size() - 1))).preStream);
    }

    private boolean isBar(Lbd lbd, int idx) {
        return lbd instanceof Lambda && !((Lambda)lbd).isUsed(idx);
    }

    private Thing executeCmd(Env env, Lbd lbd, Thing streamElement, int stridx, List<Thing> prestream, int beforeSize) {
        switch (lbd.getArgumentCount()) {
            case 0: {
                throw new IllegalStateException("when");
            }
            case 1: {
                ArrayList<Thing> args = new ArrayList<Thing>();
                args.add(streamElement);
                return lbd.exec(args);
            }
            case 2: {
                ArrayList<Thing> args = new ArrayList<Thing>();
                args.add(streamElement);
                args.add(Number.n("" + stridx));
                return lbd.exec(args);
            }
            case 3: {
                ArrayList<Thing> args = new ArrayList<Thing>();
                args.add(streamElement);
                args.add(Number.n("" + stridx));
                if (this.isBar(lbd, 2)) {
                    args.add(Null.n());
                } else {
                    args.add(Lst.n(new ArrayList<Thing>(prestream)));
                }
                return lbd.exec(args);
            }
            case 4: {
                ArrayList<Thing> args = new ArrayList<Thing>();
                args.add(streamElement);
                args.add(Number.n("" + stridx));
                if (this.isBar(lbd, 2)) {
                    args.add(Null.n());
                } else {
                    args.add(Lst.n(new ArrayList<Thing>(prestream)));
                }
                if (this.isBar(lbd, 3)) {
                    args.add(Null.n());
                } else {
                    args.add(Number.n("" + beforeSize));
                }
                return lbd.exec(args);
            }
        }
        throw new IllegalStateException("no before yet: " + lbd);
    }

    private static class FlowBlock {
        public List<Thing> preStream = new ArrayList<Thing>();
        public int streamIdx = -1;
        public Lazy cmd;
        public Lbd todo;

        private FlowBlock() {
        }

        public void add(Thing current) {
            this.preStream.add(current);
        }

        public int size() {
            if (this.streamIdx >= 0) {
                return this.streamIdx;
            }
            return this.preStream.size();
        }
    }
}

