package de.pfabulist.lisplight;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Read {

    public static class Pair {
        public String str = "";
        public Optional<Thing> thing = Optional.empty();

        public Pair( String str, Optional<Thing> token ) {
            this.str = str;
            thing = token;
        }

    }

    private String forget( String in ) {
        int idx = 0;
        while( idx < in.length() ) {
            switch( in.charAt( idx ) ) {
                case ' ':
                case '\t':
                case '\n':
                    break;
                default:
                    return in.substring( idx, in.length() );

            }

            idx++;
        }

        return "";

    }

    // can return error,

    public Pair read( String in ) {
        in = forget( in );

        if( in.equals( "" ) ) {
            return new Pair( "", Optional.empty() );
        }

        char current = in.charAt( 0 );

        if( current == '"' ) {
            return readString( in );
        }

        if( current == '(' ) {
            return readList( in );
        }

        if( current == ')' ) {
            return new Pair( in, Optional.empty() );
        }

        return readToken( in );
    }

    public static Thing n( String in ) {
        return new Read().read( in ).thing.
                orElseThrow( () -> new IllegalStateException( "syntax error of: " + in ) );
    }





    private Thing base( String str ) {
        switch( str.charAt( 0 ) ) {
            case '@':
            case '!':
            case ':':
                return new Env().basic( str );

            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                return Number.n( str );

            default:
                return Symbol.n( str );

        }

    }

    private Pair readToken( String in ) {
        for( int idx = 0; idx < in.length(); idx++ ) {
            switch( in.charAt( idx ) ) {
                case '(':
                case ')':
                case '\n':
                case '\r':
                case '\t':
                case ' ':
                    return new Pair( in.substring( idx ),
                                     Optional.of(   base( in.substring( 0, idx ) ) ) );

            }
        }
        return new Pair( "",
                         Optional.of( base( in.substring( 0, in.length() ) ) ) );
    }

    private Pair readList( String in ) {
        List<Thing> ret = new ArrayList<>();
        in = in.substring( 1 );

        while( true ) {
            Pair pair = read( in );
            if( !pair.thing.isPresent() ) {
                if ( pair.str.length() == 0 ) {
                    throw new IllegalStateException( "ende? 1" );
                }
                if( pair.str.charAt( 0 ) != ')' ) {
                    throw new IllegalStateException( "ende?" );
                }

                return new Pair( pair.str.substring( 1 ), Optional.of( Lst.n( ret ) ) );
            }

            ret.add( pair.thing.get() );
            in = pair.str;
        }

        //throw new IllegalStateException( "sfds" );
    }

    private Pair readString( String in ) {
        int pos = in.indexOf( '"', 1 );
        if( pos < 1 ) {
            throw new IllegalStateException( "string not closed" );
        }
        return new Pair( in.substring( pos + 1, in.length() ),
                         Optional.of( Strng.n( in.substring( 1, pos ) ) ) );
    }
}
