package de.pfabulist.lisplight;

import javafx.util.converter.BigIntegerStringConverter;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class ListLbd implements Lbd {

    private final String name;

    public ListLbd( String name ) {
        this.name = name;
    }

    static public void addLambdas( Map<String,Thing> map ) {
        map.put( "list", new ListLbd( "list" ) );
        map.put( "rget", new ListLbd( "rget" ) );
    }


    @Override
    public Thing exec( List<Thing> res ) {
        switch( name ) {
            case "list":
                return Lst.n( res );
            case "rget": {
                Lst lst = n( res, 0 );
                int size = lst.size();
                int idx = ((Number)res.get( 1)).bi.intValueExact();

                int realIdx = size -1 - idx;

                if ( realIdx >= size || realIdx < 0 ) {
                    return new Exc( "rget bad idx " + idx );
                }

                return lst.get( size -1 - idx );
            }
            default:

                throw new IllegalStateException( "unknown ldb" + name );
        }
    }

    private Lst n( List<Thing> res, int idx  ) {
        if ( res.size() <= idx ) {
            throw new IllegalStateException( "need more arguments: " + name + ", " + idx );
        }

        Thing ret = res.get( idx );

        if ( ret instanceof Lst ) {
            return (Lst) ret;
        }

        throw new IllegalStateException( "not a number arguments: " + name + ", " + ret );
    }


    @Override
    public int getArgumentCount() {
        switch( name ) {
            case "list":
                return -1;
            case "rget":
                return 2;
            default:
                return 0;
        }
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }
}
