package de.pfabulist.lisplight;

import java.util.Objects;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Exc implements Thing {

    private final String what;

    public Exc( String what ) {
        this.what = what;
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }

    @Override
    public String toString() {
        return "(@Exc " + what + ")";  // todo string handling
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;
        Exc exc = (Exc) o;
        return Objects.equals( what, exc.what );
    }

    @Override
    public int hashCode() {
        return Objects.hash( what );
    }
}
