package de.pfabulist.lisplight;

import java.util.Objects;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Bool implements Thing {
    private final boolean on;

    public Bool( boolean on ) {
        this.on = on;
    }

  
    @Override
    public String toString() {
        return on ? "@t" : "@f";
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }

    public boolean is() {
        return on;
    }

    public static Bool tru() {
        return new Bool( true );
    }
    public static Bool fals() {
        return new Bool( false );
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;
        Bool bool = (Bool) o;
        return on == bool.on;
    }

    @Override
    public int hashCode() {
        return Objects.hash( on );
    }
}
