/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Bool;
import de.pfabulist.lisplight.Env;
import de.pfabulist.lisplight.Thing;
import java.math.BigInteger;
import java.util.Objects;

public class Number
implements Thing {
    final BigInteger bi;

    public Number(BigInteger bi) {
        this.bi = bi;
    }

    @Override
    public Thing eval(Env env) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Number number = (Number)o;
        return Objects.equals(this.bi, number.bi);
    }

    public int hashCode() {
        return Objects.hash(this.bi);
    }

    public static Thing n(String str) {
        return new Number(new BigInteger(str));
    }

    public String toString() {
        return this.bi.toString();
    }

    public Thing plus(Number number) {
        return new Number(this.bi.add(number.bi));
    }

    public Thing remainder(Number number) {
        return new Number(this.bi.remainder(number.bi));
    }

    public Thing greater(Number number) {
        return new Bool(this.bi.compareTo(number.bi) > 0);
    }

    int compareTo(Number number) {
        return this.bi.compareTo(number.bi);
    }

    public Thing minus(Number number) {
        return new Number(this.bi.add(number.bi));
    }

    public Thing times(Number n) {
        return new Number(this.bi.multiply(n.bi));
    }
}

