package de.pfabulist.lisplight;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Lst implements Stream,Thing{
    private List<Thing> lst;

    @Override
    public String toString() {
        return "(" + lst.stream().map( Object::toString ).collect( Collectors.joining( " " ) ) + ")";
    }

    @Override
    public Thing eval( Env env ) {

        if ( lst.size() == 0 ) {
            //throw new IllegalStateException( "empty list" );
            return Lst.n();
        }

        Thing top = lst.get( 0 );
        top = top.eval( env );

        if ( top instanceof Lazy ) {
            return ((Lazy)top).exec( env, lst.subList( 1, lst.size() ) );
        }

        List<Thing> res = lst.stream().map( e -> e.eval( env ) ).collect( Collectors.toList());

        Thing func = res.get( 0 );
        if ( !func.isFunction() ) {
            throw new IllegalStateException( "no function " + func );
        }

        return ((Lbd)func).exec( res.subList( 1, res.size() ) );
    }

    public Lst( Thing ... things ) {
        lst = Arrays.asList( things );
    }
    public Lst( List<Thing>  things ) {
        lst = things;
    }

//    public Lst add( Thing thing ) {
//        lst.add( thing );
//        return new Lst( lst );
//    }

    public static Lst n( Thing ... things ) {
        return new Lst( things );
    }
    public static Lst n( List<Thing>  things ) {
        return new Lst( things );
    }

    public List<Thing> getInternal() {
        return lst;
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;

        List<Thing> left = lst;

        List<Thing> right = ((Lst) o).lst;


        if ( lst.size() == 0 ) {
            return right.size() == 0;
        }

        if ( right.size() == 0 ) {
            return false;
        }

        for ( int i = 0; i<lst.size(); i++ ) {
            if ( !lst.get( i ).equals( right.get(i) )) {
                return false;
            }

        }

        return true;
        
    }

    @Override
    public int hashCode() {

        int ret = 0;
        for ( int i = 0; i < lst.size(); i++){
            ret = ret * 31 + lst.hashCode();
        }
        return ret;
    }

    @Override
    public Thing get( int i ) {
        return lst.get(i);
    }

    @Override
    public boolean has( int stridx ) {
        return lst.size() > stridx;
    }

    public int size() {
        return lst.size();
    }
}
