package de.pfabulist.lisplight;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class LazyStream implements Stream {
    private final Lbd lbd;
    private final Env env;

    public LazyStream( Env env, Lbd lbd ) {
        this.lbd = lbd;
        this.env = env;
    }

    @Override
    public Thing get( int i ) {
        return Lst.n( lbd, Number.n( "" + i)).eval( env );
    }

    @Override
    public boolean has( int stridx ) {
        return true; // todo
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }
}
