package de.pfabulist.lisplight;

import java.util.ArrayList;
import java.util.List;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Flow {

    private static class FlowBlock {
        public List<Thing> preStream = new ArrayList<>();
        public int streamIdx = -1;
        public Lazy cmd;
        public Lbd todo;

        public void add( Thing current ) {
            preStream.add( current );
        }

        public int size() {
            if ( streamIdx >= 0 ) {
                return streamIdx;
            }
            return preStream.size();
        }
    }

//    private boolean goon( )  {}

    public Thing flow( Env env, List<Thing> lst ) {
        List<FlowBlock> blocks = new ArrayList<>();

        // fill them
        FlowBlock first = new FlowBlock();
        Thing prest = lst.get( 0 ).eval( env );
//        first.preStream = prest instanceof Stream ?
//                (Stream) prest :
//                new LazyStream( env, (Lbd) prest );

        blocks.add( first );

        Stream startStream = prest instanceof Stream ? (Stream) prest : new LazyStream( env, (Lbd) prest );


        

        for ( int idx = 1; idx < lst.size(); idx++ ) {
            FlowBlock nextBlock = new FlowBlock();
            //nextBlock.preStream = Lst.n( new ArrayList<>());

            if ( !(lst.get(idx) instanceof Lst )  ) {
                throw new IllegalStateException( "just lst cmds not: " + lst.get(idx) );
            }
            Lst cmd = (Lst) lst.get( idx);
            if ( cmd.size() != 2 || !(cmd.get( 0 ) instanceof Lazy)) {
                throw new IllegalStateException( "just lst cmds not: " + lst.get(idx) );
            }
    
            nextBlock.cmd = (Lazy) cmd.get( 0 );
            nextBlock.todo = (Lbd) cmd.get( 1 ).eval( env );    // todo more checks

            blocks.add( nextBlock );

        }

        // run it
        boolean streamRunning = true;

        for ( blocks.get(0).streamIdx = 0;
              streamRunning && startStream.has( blocks.get(0).streamIdx) ;
              blocks.get(0).streamIdx++ ) {
            
            boolean cmdRunning = true;
            Thing current = startStream.get( blocks.get(0).streamIdx );

            for( int idx = 1; idx < lst.size() && cmdRunning; idx++ ) {
                
                FlowBlock oldBlock = blocks.get( idx - 1 );
                FlowBlock nowBlock = blocks.get(idx);
                Thing cmdRes = executeCmd( env, nowBlock.todo, current, oldBlock.size(), nowBlock.preStream );

                switch (nowBlock.cmd.toString()) {
                    case ":filter": {
                        Bool takep = (Bool) cmdRes;
                        if( takep.is() ) {
                            nowBlock.add( current );
                        } else {
                            cmdRunning = false;
                        }
                        break;
                    }
                    case ":while": {

                        Bool takep = (Bool) cmdRes;
                        if( !takep.is() ) {
                                // get next from preStream, and all follow
                            streamRunning = false;
                        } else {
                            nowBlock.add( current );
                        }
                        break;

                    }
                    case ":map": {
                        nowBlock.add( cmdRes );
                        current = cmdRes;
                        break;

                    }
                    case ":find": {
                            if ( ((Bool)cmdRes).is() ) {
                                nowBlock.add( current );
                                streamRunning = false;
                            }
                            cmdRunning = false;
                            break;
                   }

                    default:
                        throw new IllegalStateException( "no " + nowBlock.cmd );
                }
            }
        }

        if ( lst.size() == 1 ) {
            throw new IllegalStateException( "not yet" );
        }

        return Lst.n( blocks.get( lst.size()-1).preStream );

    }

//    public Thing flow( Env env, List<Thing> lst ) {
//        int stridx = 0;
//        Thing prest = lst.get( 0 ).eval( env );
//        Stream st = prest instanceof Stream ?
//                (Stream) prest :
//                new LazyStream( env, (Lbd) prest );
//
//
//        List<Thing> allback = new ArrayList<>();
//        boolean general = true;
//
//        while (true ){
//            Thing result = Null.n();
//            if ( !st.has( stridx ) || !general) {
//                break;
//            }
//
//            Thing current = st.get( stridx );
//
//            // cmd loop
//            int cmdidx = 1;
//            boolean docmds = true;
//            while( docmds ) {
//                if ( cmdidx >= lst.size() ) {
//                    //docmds = false;
//                    break;
//                }
//
//                Lst cmdlst = (Lst) lst.get( cmdidx ); // (cmd lbd)
//                Lazy cmd = (Lazy) cmdlst.get( 0 );
//                switch( cmd.toString() ) {
//                    case "!filter": {
//                        Lst now = Lst.n( cmdlst.get( 1 ).eval( env ),  // execute lbd on current preStream elem
//                                         current );
//                        Bool res = (Bool) now.eval( env );
//                        if( res.is() ) {
//                            // take it go on
//                            result = current;//st.get( cmdidx );
//                            cmdidx++;
//                        } else {
//                            // get next from preStream
//                            docmds = false;
//                        }
//                        break;
//                    }
//                    case "!map": {
//                        Lst now = Lst.n( cmdlst.get( 1 ).eval( env ),  // execute lbd on current preStream elem
//                                         current );
//                        current = now.eval( env );
//                        result = current;
//                        cmdidx++;
//                        break;
//                    }
//                    case "!while": {
//
//                        Bool res = (Bool) executeCmd( env, cmdlst, current, Number.n( "" + allback.size() ));//"" + stridx ) );
//                        if( res.is() ) {
//                            // take it go on
//                            result = current;//st.get( cmdidx );
//                            cmdidx++;
//                        } else {
//                            // get next from preStream, and all follow
//                            docmds = false;
//                            general = false;
//                        }
//                        break;
//                    }
//                    default:
//                        throw new IllegalStateException( "no " + cmd );
//                }
//            }
//            stridx++;
//            if ( docmds ) {
//                allback.add( result );
//            }
//        }
//
//        return Lst.n( allback );
//    }


    private Thing executeCmd( Env env, Lbd lbd, Thing streamElement, int stridx, List<Thing> prestream) {
//        // cmd : (!someting lbd)
//        if ( cmd.getInternal().size() > 2 ) {
//            throw new IllegalStateException( "preStream cmd not in right form: " + cmd );
//        }
//
//        Thing lbdp = cmd.get( 1 ).eval( env );
//        if ( !(lbdp instanceof Lbd )) {
//            throw new IllegalStateException( "preStream cmd not in lbd right form: " + cmd );
//        }

     //   Lbd lbd = (Lbd) lbdp;

        switch( lbd.getArgumentCount() ) {
            case 0:
                throw new IllegalStateException( "when" );
            case 1:
                return Lst.n( lbd,  // execute lbd on current preStream elem
                              streamElement ).
                        eval( env );
            case 2:
                return Lst.n( lbd,  // execute lbd on current preStream elem
                              streamElement,
                              Number.n( "" + stridx) ).
                        eval( env );
            case 3: {
                List<Thing> args = new ArrayList<Thing>();
                args.add( streamElement );
                args.add( Number.n( "" + stridx ));
                args.add( Lst.n( new ArrayList<>( prestream )));
                return lbd.exec( args );
//                return Lst.n( lbd,  // execute lbd on current preStream elem
//                              streamElement,
//                              Number.n( "" + stridx ),
//                              Lst.n( prestream ) ).
//                        eval( env );
            }
            default:
                    throw new IllegalStateException( "no before yet: " + lbd );

        }


    }
}
