package de.pfabulist.lisplight;

import java.util.Objects;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Symbol implements Thing {
    private final String sym;

    public Symbol( String sym ) {
        this.sym = sym;
        if ( sym.length() == 0 || sym.charAt( 0 ) == '@') {
//            if ( !sym.equals( "@idx" )) {
                throw new IllegalStateException( "cant Symbol " + sym );
  //          }
        }
    }

    @Override
    public String toString() {
        return sym;
    }

    @Override
    public Thing eval( Env env ) {
        return env.eval( sym );
    }

    public static Symbol n( String sym ) {
        return new Symbol( sym );
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;
        Symbol symbol = (Symbol) o;
        return Objects.equals( sym, symbol.sym );
    }

    @Override
    public int hashCode() {

        return Objects.hash( sym );
    }
}
