package de.pfabulist.lisplight;

import java.util.Objects;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Strng implements Thing {

    private String str;

    public Strng( String str ) {
        this.str = str;
    }

    @Override
    public String toString() {
        return '"' + str + '"';
    }


    @Override
    public Thing eval( Env env ) {
        return this;
    }

    public String get(){
        return str;
    }

    public static Strng n( String str ) {
        return new Strng( str );
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;
        Strng strng = (Strng) o;
        return Objects.equals( str, strng.str );
    }

    @Override
    public int hashCode() {
        return Objects.hash( str );
    }
}
