package de.pfabulist.lisplight;

import java.math.BigInteger;
import java.util.Objects;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Number implements Thing {

    final BigInteger bi;

    public Number( BigInteger bi ) {
        this.bi = bi;
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }

    @Override
    public boolean equals( Object o ) {
        if( this == o ) return true;
        if( o == null || getClass() != o.getClass() ) return false;
        Number number = (Number) o;
        return Objects.equals( bi, number.bi );
    }

    @Override
    public int hashCode() {
        return Objects.hash( bi );
    }

    public static Thing n( String str ) {
        return new Number( new BigInteger( str ));
    }

    @Override
    public String toString() {
        return bi.toString();
    }

    public Thing plus( Number number ) {
        return new Number(bi.add( number.bi ));
    }

    public Thing remainder( Number number ) {
        return new Number(bi.remainder( number.bi ));
    }

    public Thing greater( Number number ) {
        return new Bool( bi.compareTo( number.bi ) > 0 );
    }
}
