package de.pfabulist.lisplight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Lambda implements Lbd {

    private final List<String> names;
    private final Thing body;
    private final Env env;

    public Lambda( Env env, Thing body, List<String> names ) {
        this.names = names;
        this.body = body;
        this.env = env;

    }

    @Override
    public String toString() {
        return  "(!lbd ("
        + names.stream().collect( Collectors.joining( " " ) ) + ") " +
                body +
                ")";
    }

    @Override
    public Thing eval( Env env ) {
        return this;
    }


    @Override
    public Thing exec( List<Thing> res ) {
        Map<String, Thing> next = new HashMap<>();
        for ( int i = 0; i<names.size(); i++ ) {
            next.put( names.get(i), res.get(i) );
        }
        Env exectime = env.next( next );
        return body.eval( exectime );
    }

    @Override
    public int getArgumentCount() {
        return names.size();
    }
}
