package de.pfabulist.lisplight;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Home implements Lbd {
    private final String name;

    public Home( String name ) {
        this.name = name;
    }

    @Override
    public Thing exec( List<Thing> res ) {
        switch( name ) {
            case "++":
                return new Strng( res.stream().
                        map( x -> ((Strng)x).get()).
                        collect( Collectors.joining("")));
            case "+" :
                return ((Number)res.get( 0 )).plus( (Number)res.get( 1 ));
            case ">" :
                return ((Number)res.get( 0 )).greater( (Number)res.get( 1 ));
            case "remainder" :
                return ((Number)res.get( 0 )).remainder( (Number)res.get( 1 ));
            case "list" :
                return Lst.n( res );
            case "empty?" :
                return new Bool(((Lst)res.get(0)).size() == 0);
            case "not" :
                return new Bool( !((Bool)res.get( 0 )).is() );
            case "print" : {
                System.out.println(res);
                return res.size() > 0 ? res.get( 0 ) : Null.n();
            }

            case "==" : {
                if( res.size() != 2 ) {
                    throw new IllegalStateException( "== got " + res.size() );
                }

                Thing left = res.get(0);
                Thing right = res.get(1);

                return new Bool( left.equals( right ));
                
            }
                default:
                    throw new IllegalStateException( "not" );
        }

    }

    @Override
    public int getArgumentCount() {
        switch( name ) {
            case "++":
                return 2; // at least
            case "+" :
                return 2;
            case ">" :
                return 2;
            case "remainder" :
                return 2;
            case "list" :
                return 0;
            case "==" : 
                return 2;
                default:
                    throw new IllegalStateException( "argument count, no home" );
            }
    }

    @Override
    public String toString() {
        return name;
    }


    @Override
    public Thing eval( Env env ) {
        return this;
//        throw new IllegalStateException( "null" );
    }

    @Override
    public boolean isFunction() {
        return true;
    }
}
