package de.pfabulist.lisplight;

import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Env {

    private final Optional<Env> before;

    private final Map<String,Thing> map;

    public Env() {
        before = Optional.empty();
        map = new HashMap<>();

        map.put( "++", new Home( "++" ) );
        map.put( "==", new Home( "==" ) );
        map.put( "+", new Home( "+" ) );
        map.put( "remainder", new Home( "remainder" ) );
        map.put( "list", new Home( "list" ) );
        map.put( ">", new Home( ">" ) );
        map.put( "print", new Home( "print" ) );
        map.put( "not", new Home( "not" ) );
        map.put( "empty?", new Home( "empty?" ) );

        map.put( "!if", new LazyHome( "!if" ) );
        map.put( "!lbd", new LazyHome( "!lbd" ) );
        map.put( "!let", new LazyHome( "!let" ) );
        map.put( "!set", new LazyHome( "!set" ) );
        map.put( "!flow", new LazyHome( "!flow" ) );
        map.put( "!filter", new LazyHome( "!filter" ) );
        map.put( "!map", new LazyHome( "!map" ) );
        map.put( "!while", new LazyHome( "!while" ) );
        map.put( "!find", new LazyHome( "!find" ) );

        map.put( "@t", Bool.tru() );
        map.put( "@f", Bool.fals() );

    }

    public Thing basic( String str ) {
        @Nullable Thing res = map.get( str );
        if ( res == null ) {
            throw new IllegalStateException( "todo, " + str );
        }

        return res;
    }

//    private Env( Env before, Set<String> next ) {
//        this.before = Optional.of( before );
//        saved = next;
//
//
//    }

    private Env( Env before, Map<String, Thing> next ) {
        this.before = Optional.of( before );
        this.map = next;
    }


    public Thing eval( String name ) {
        @Nullable Thing found = map.get( name );

        if ( found != null ) {
            if ( found instanceof Dont) {
                throw new IllegalStateException( "dont from " + name );
            }
            return found;
        }

        if ( before.isPresent()) {
            return before.get().eval( name );
        }

        throw new IllegalStateException( "not bound: " + name );
    }

//    public Env next( Set<String> words ) {
//        return new Env( this, words );
//    }

    public Env next( Map<String, Thing> words ) {
        return new Env( this, words );
    }

    public void set( String name, Thing val ) {
        @Nullable Thing found = map.get( name );

        if ( found == null ) {
            throw new IllegalStateException( "not bound: " + name );
        }

        if ( !(found instanceof Dont)) {
                throw new IllegalStateException( "already set " + name );

        }

        map.put( name, val );

    }
}
