/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lisplight;

import de.pfabulist.lisplight.Bool;
import de.pfabulist.lisplight.Dont;
import de.pfabulist.lisplight.Home;
import de.pfabulist.lisplight.LazyHome;
import de.pfabulist.lisplight.Thing;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Env {
    private final Optional<Env> before;
    private final Map<String, Thing> map;

    public Env() {
        this.before = Optional.empty();
        this.map = new HashMap<String, Thing>();
        this.map.put("++", new Home("++"));
        this.map.put("==", new Home("=="));
        this.map.put("+", new Home("+"));
        this.map.put("remainder", new Home("remainder"));
        this.map.put("list", new Home("list"));
        this.map.put(">", new Home(">"));
        this.map.put("print", new Home("print"));
        this.map.put("!if", new LazyHome("!if"));
        this.map.put("!lbd", new LazyHome("!lbd"));
        this.map.put("!let", new LazyHome("!let"));
        this.map.put("!set", new LazyHome("!set"));
        this.map.put("!flow", new LazyHome("!flow"));
        this.map.put("!filter", new LazyHome("!filter"));
        this.map.put("!map", new LazyHome("!map"));
        this.map.put("!while", new LazyHome("!while"));
        this.map.put("@t", Bool.tru());
        this.map.put("@f", Bool.fals());
    }

    public Thing basic(String str) {
        Thing res = this.map.get(str);
        if (res == null) {
            throw new IllegalStateException("todo, " + str);
        }
        return res;
    }

    private Env(Env before, Map<String, Thing> next) {
        this.before = Optional.of(before);
        this.map = next;
    }

    public Thing eval(String name) {
        Thing found = this.map.get(name);
        if (found != null) {
            if (found instanceof Dont) {
                throw new IllegalStateException("dont from " + name);
            }
            return found;
        }
        if (this.before.isPresent()) {
            return this.before.get().eval(name);
        }
        throw new IllegalStateException("not bound: " + name);
    }

    public Env next(Map<String, Thing> words) {
        return new Env(this, words);
    }

    public void set(String name, Thing val) {
        Thing found = this.map.get(name);
        if (found == null) {
            throw new IllegalStateException("not bound: " + name);
        }
        if (!(found instanceof Dont)) {
            throw new IllegalStateException("already set " + name);
        }
        this.map.put(name, val);
    }
}

