package de.pfabulist.lisplight;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Copyright (c) 2006 - 2018, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Flow {

    public Thing flow( Env env, List<Thing> lst ) {
        int stridx = 0;
        Thing prest = lst.get( 0 ).eval( env );
        Stream st = prest instanceof Stream ?
                (Stream) prest :
                new LazyStream( env, (Lbd) prest );


        List<Thing> allback = new ArrayList<>();
        boolean general = true;

        while (true ){
            Thing result = Null.n();
            if ( !st.has( stridx ) || !general) {
                break;
            }

            Thing current = st.get( stridx );

            // cmd loop
            int cmdidx = 1;
            boolean docmds = true;
            while( docmds ) {
                if ( cmdidx >= lst.size() ) {
                    //docmds = false;
                    break;
                }

                Lst cmdlst = (Lst) lst.get( cmdidx ); // (cmd lbd)
                Lazy cmd = (Lazy) cmdlst.get( 0 );
                switch( cmd.toString() ) {
                    case "!filter": {
                        Lst now = Lst.n( cmdlst.get( 1 ).eval( env ),  // execute lbd on current stream elem
                                         current );
                        Bool res = (Bool) now.eval( env );
                        if( res.is() ) {
                            // take it go on
                            result = current;//st.get( cmdidx );
                            cmdidx++;
                        } else {
                            // get next from stream
                            docmds = false;
                        }
                        break;
                    }
                    case "!map": {
                        Lst now = Lst.n( cmdlst.get( 1 ).eval( env ),  // execute lbd on current stream elem
                                         current );
                        current = now.eval( env );
                        result = current;
                        cmdidx++;
                        break;
                    }
                    case "!while": {

                        Bool res = (Bool) executeCmd( env, cmdlst, current, Number.n( "" + allback.size() ));//"" + stridx ) );
                        if( res.is() ) {
                            // take it go on
                            result = current;//st.get( cmdidx );
                            cmdidx++;
                        } else {
                            // get next from stream, and all follow
                            docmds = false;
                            general = false;
                        }
                        break;
                    }
                    default:
                        throw new IllegalStateException( "no " + cmd );
                }
            }
            stridx++;
            if ( docmds ) {
                allback.add( result );
            }
        }

        return Lst.n( allback );
    }


    private Thing executeCmd( Env env, Lst cmd, Thing streamElement, Thing streamIndex ) {
        // cmd : (!someting lbd)
        if ( cmd.getInternal().size() > 2 ) {
            throw new IllegalStateException( "stream cmd not in right form: " + cmd );
        }

        Thing lbdp = cmd.get( 1 ).eval( env );
        if ( !(lbdp instanceof Lbd )) {
            throw new IllegalStateException( "stream cmd not in lbd right form: " + cmd );
        }

        Lbd lbd = (Lbd) lbdp;

        switch( lbd.getArgumentCount() ) {
            case 0:
                throw new IllegalStateException( "when" );
            case 1:
                return Lst.n( lbd,  // execute lbd on current stream elem
                              streamElement ).eval( env );
            case 2:
                return Lst.n( lbd,  // execute lbd on current stream elem
                              streamElement,
                              streamIndex ).eval( env );
                default:
                    throw new IllegalStateException( "no before yet: " + cmd );

        }


    }
}
