/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.toti;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.elsewhere.Elsewhere;
import de.pfabulist.elsewhere.FSElsewhere;
import de.pfabulist.kleinod.collection.P;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niodav.NioDavServer;
import de.pfabulist.lindwurm.stellvertreter.StellvertreterBuilder;
import de.pfabulist.lindwurm.stellvertreter.StellvertreterFS;
import de.pfabulist.lindwurm.toti.CollectConf;
import de.pfabulist.lindwurm.toti.Conf;
import de.pfabulist.unchecked.Filess;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class Repl {
    public static void main(String[] args) {
        Path host = Repl.getCurrentDir();
        TotiLogger logger = new TotiLogger(host.resolve("log"));
        Log.setLogger((Log.Logger)logger);
        System.out.println("Welcome to Iceberg 0.3");
        System.out.println("you are here: " + host);
        if (!Files.exists(host, new LinkOption[0]) || !Files.isDirectory(host, new LinkOption[0])) {
            System.out.println("current dir must be an existing directory");
            System.exit(1);
        }
        if (StellvertreterFS.running((Path)host)) {
            System.out.println("current host is in use");
            System.exit(1);
        }
        Conf conf = CollectConf.existingOrDefault(host).getUserInput().build();
        logger.onOff(conf.logToConsole);
        Path root = Repl.getStellvertreterRoot(host, conf);
        NioDavServer server = Repl.getAndStartServer(root);
        Filess.createDirectory((Path)Paths.get("/Volumes/" + conf.volume, new String[0]), (FileAttribute[])new FileAttribute[0]);
        Repl.mount(conf, server.getPort());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Repl.umount(conf)));
    }

    private static NioDavServer getAndStartServer(Path root) {
        int port = 12000;
        while (!Repl.available(port)) {
            ++port;
        }
        NioDavServer server = new NioDavServer(root, port).start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((NioDavServer)server).stop()));
        return server;
    }

    private static Path getStellvertreterRoot(Path host, Conf conf) {
        if (conf.elsewhere != null) {
            return StellvertreterBuilder.stellvertreter().host(host).password(conf.passwd.toCharArray()).spaceControl(conf.spaceLimit).elsewhere((Elsewhere)new FSElsewhere(conf.elsewhere)).build().getPath("/play", new String[0]);
        }
        return StellvertreterBuilder.stellvertreter().host(host).password(conf.passwd.toCharArray()).spaceControl(conf.spaceLimit).build().getPath("/play", new String[0]);
    }

    public static Path getCurrentDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean available(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored2) {
            return true;
        }
    }

    public static <B, C, D> D with(Supplier<P<B, C>> fct, BiFunction<B, C, D> bound) {
        P<B, C> ret = fct.get();
        Object b = ret.i0;
        Object c = ret.i1;
        return bound.apply(ret.i0, ret.i1);
    }

    private static void mount(Conf conf, int port) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(new String[]{"mount_webdav", "-v", conf.volume, "http://localhost:" + port, "/Volumes/" + conf.volume});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void umount(Conf conf) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(new String[]{"umount", "/Volumes/" + conf.volume});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class TotiLogger
    extends Log.Logger {
        private final Path file;
        private boolean toSTD = true;
        private boolean toFile = true;

        public TotiLogger(Path file) {
            this.file = file;
        }

        public void showLog(boolean on) {
            this.toSTD = on;
        }

        protected void print(String message) {
            if (this.toSTD) {
                super.print(message);
            }
            Filess.write((Path)this.file, (byte[])Strings.getBytes((String)(message + "\n")), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.WRITE, StandardOpenOption.CREATE});
        }

        public boolean toggle() {
            this.toSTD = !this.toSTD;
            return this.toSTD;
        }

        public void onOff(boolean on) {
            this.toSTD = on;
        }
    }
}

