/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.toti;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.stellvertreter.PasswordHash;
import de.pfabulist.lindwurm.stellvertreter.Stellvertreter;
import de.pfabulist.lindwurm.toti.Conf;
import de.pfabulist.unchecked.Filess;
import de.pfabulist.unchecked.Unchecked;
import java.io.Console;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.json.JSONObject;

public class CollectConf {
    private final Conf conf;
    private final boolean existing;
    private final Console console = System.console();
    private final Path host;

    private CollectConf(Conf conf, boolean existing, Path host) {
        this.conf = conf;
        this.existing = existing;
        this.host = host;
    }

    public static CollectConf existingOrDefault(Path host) {
        if (!Stellvertreter.isHost((Path)host)) {
            return new CollectConf(new Conf(), false, host);
        }
        Path confFile = CollectConf.getIcebergConfPath(host);
        if (!Files.exists(confFile, new LinkOption[0])) {
            return new CollectConf(new Conf(), true, host);
        }
        try {
            String content = Strings.newString((byte[])Files.readAllBytes(confFile));
            JSONObject jsonObject = new JSONObject(content);
            return new CollectConf(Conf.valueOf(jsonObject), true, host);
        }
        catch (IOException e) {
            Log.warn((String)"toti conf corrupt", (Throwable)e);
            return new CollectConf(new Conf(), true, host);
        }
    }

    private static Path getIcebergConfPath(Path host) {
        return host.resolve(".toti.conf");
    }

    public CollectConf getUserInput() {
        if (this.existing) {
            System.out.println("opening an existing iceberg");
        } else if (!CollectConf.isEmpty(this.host)) {
            System.out.println("[error] not an existing host but in use for other purpose (not empty)");
            System.exit(1);
        } else {
            System.out.println("creating a new iceberg ...");
        }
        this.conf.passwd = this.getPasswd();
        this.conf.volume = this.getVolume();
        this.conf.logToConsole = this.getLogToConsole();
        this.conf.logToFile = this.getBoolean("log to file", this.conf.logToFile);
        if (!this.existing) {
            this.conf.elsewhere = this.getElseWhere();
        }
        this.conf.spaceLimit = this.getSpaceLimit();
        return this;
    }

    private long getSpaceLimit() {
        if (this.existing ? !CollectConf.hasElsewheres(this.host) : this.conf.elsewhere == null) {
            return -1L;
        }
        String space;
        while ((space = this.console.readLine("max local space [" + this.conf.spaceLimit + "]> ", new Object[0])).length() != 0) {
            try {
                long sp = Long.valueOf(space);
                return sp;
            }
            catch (NumberFormatException e) {
                System.out.println("a long please");
                continue;
            }
            break;
        }
        return this.conf.spaceLimit;
    }

    private Path getElseWhere() {
        String el;
        while ((el = this.console.readLine("Elsewhere [none]> ", new Object[0])).length() != 0) {
            Path els = Paths.get(el, new String[0]);
            if (Files.exists(els, new LinkOption[0]) && Files.isDirectory(els, new LinkOption[0]) && CollectConf.isEmpty(els)) {
                return els;
            }
            System.out.println("else must be an existing empty dir");
        }
        return null;
    }

    private boolean getLogToConsole() {
        return this.getBoolean("log to console", this.conf.logToConsole);
    }

    private boolean getBoolean(String message, boolean dflt) {
        String l;
        while ((l = this.console.readLine(message + "[" + (dflt ? "Yn]" : "yN]> "), new Object[0])).length() > 0) {
            if (l.equals("y")) {
                return true;
            }
            if (l.equals("n")) {
                return false;
            }
            System.out.println("'y' or 'n' or enter");
        }
        return dflt;
    }

    private String getVolume() {
        String vol = this.conf.volume;
        if (this.conf.volume == null) {
            vol = this.host.getFileName().toString();
        }
        while (true) {
            String v;
            if ((v = this.console.readLine("volume [" + vol + "]> ", new Object[0])).length() > 0) {
                vol = v;
            }
            if (!Files.exists(Paths.get("/Volumes/" + vol, new String[0]), new LinkOption[0])) break;
            System.out.println("[error] volume in use choose an other");
        }
        return vol;
    }

    private String getPasswd() {
        if (this.existing) {
            return this.getExistingPassword();
        }
        return this.getNewPassword();
    }

    private String getNewPassword() {
        String passwd = "";
        while (true) {
            if ((passwd = this.console.readLine("choose password> ", new Object[0])).length() < 10) {
                System.out.println("password too short (<10)");
                continue;
            }
            String passwd2 = this.console.readLine("repeat         > ", new Object[0]);
            if (passwd.equals(passwd2)) {
                return passwd;
            }
            System.out.println("[ERROR] passwords not equal. Try again");
        }
    }

    private String getExistingPassword() {
        while (true) {
            String passwd = this.console.readLine("Passwd: ", new Object[0]);
            if (!Files.exists(this.host.resolve(".svsanity"), new LinkOption[0])) {
                System.out.printf("[WARN] not possible to validate password. Lets hope its correct.", new Object[0]);
                return passwd;
            }
            if (new PasswordHash().same(Filess.readAllBytes((Path)this.host.resolve(".svsanity")), passwd.toCharArray())) {
                return passwd;
            }
            System.out.println("[ERROR] wrong password. Try again");
        }
    }

    public Conf build() {
        Filess.write((Path)CollectConf.getIcebergConfPath(this.host), (byte[])Strings.getBytes((String)this.conf.toString()), (OpenOption[])new OpenOption[0]);
        return this.conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmpty(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Iterator<Path> iterator = stream.iterator();
            if (!iterator.hasNext()) return true;
            Path kid = iterator.next();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasElsewheres(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Path kid;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(kid = iterator.next()).getFileName().toString().startsWith(".elsewhere"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }
}

