package de.pfabulist.lindwurm.toti;

import com.esotericsoftware.minlog.Log;
import de.pfabulist.elsewhere.FSElsewhere;
import de.pfabulist.kleinod.collection.P;
import de.pfabulist.lindwurm.niodav.NioDavServer;
import de.pfabulist.lindwurm.stellvertreter.StellvertreterFS;
import de.pfabulist.unchecked.Filess;

import java.io.Console;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiFunction;
import java.util.function.Supplier;

import static de.pfabulist.kleinod.text.Strings.getBytes;
import static de.pfabulist.lindwurm.stellvertreter.StellvertreterBuilder.stellvertreter;
import static de.pfabulist.unchecked.Unchecked.u;
import static java.nio.file.StandardOpenOption.*;
import static java.nio.file.StandardOpenOption.APPEND;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

public class Repl {

    public static void main( String[] args ) {

        final Path host = getCurrentDir();

        TotiLogger logger = new TotiLogger( host.resolve( "log" ) );
        Log.setLogger( logger );

        System.out.println( "Welcome to Iceberg 0.3" );
        System.out.println( "you are here: " + host );

        if( !Files.exists( host ) || !Files.isDirectory( host ) ) {
            System.out.println( "current dir must be an existing directory" );
            System.exit( 1 );
        }

        if( StellvertreterFS.running( host ) ) {
            System.out.println( "current host is in use" );
            System.exit( 1 );
        }

        Conf conf = CollectConf.existingOrDefault( host ).getUserInput().build();

        logger.onOff( conf.logToConsole );

        Path root = getStellvertreterRoot( host, conf );

        NioDavServer server = getAndStartServer( root );

        Filess.createDirectory( Paths.get( "/Volumes/" + conf.volume ) );
        mount( conf, server.getPort() );

        Runtime.getRuntime().addShutdownHook( new Thread( () -> umount( conf ) ) );


//        if( Stellvertreter.isHost( host ) ) {
//            System.out.println( "it is an existing stellvertreter host" );
//            pwd = openStell( host );
//        } else if( isEmpty( host ) ) {
//            System.out.println( "it can be a stellvertreter host" );
//            pwd = newStell( host );
//        } else {
//            System.out.println( "it is a directory in use (not empty), not suitable as stellvertreter host" );
//            System.exit( 1 );
//        }
//
//        //pwd = stellfs;
//        server = new NioDavServer( stellfs, port ).start();
//
//        System.out.println( "mkdir /Volumes/" + volumeName );
//        System.out.println( "mount_webdav -i -v " + volumeName + " http://localhost:" + port + " /Volumes/" + volumeName );
//
//        Runtime.getRuntime().addShutdownHook( new Thread( () -> {
//            if ( server != null ) {
//                server.stop();
//            }
//        }) );
//
//        while( true ) {
//            String cmd = c.readLine();
//
//            if ( cmd.equals( "exit" )) {
//                System.out.println("stopping and leaving\nbye");
//                System.exit( 0 );
//            }
//
//            if ( cmd.equals( "log" )) {
//                boolean stdLogging = logger.toggle();
//                System.out.println( "logging to stdout:" + stdLogging );
//
//            } else if ( cmd.equals( "pwd" )) {
//                System.out.println( pwd );
//
//            } else if ( cmd.equals( "ls" )) {
//                try( DirectoryStream<Path> stream = Files.newDirectoryStream( pwd ) ) {
//                    for( Path kid : stream ) {
//                        System.out.println( kid );
//                        BasicFileAttributes bfa = Files.readAttributes( kid, BasicFileAttributes.class );
//                        System.out.println( "  " + bfa );
//                    }
//                } catch( IOException e ) {
//                    e.printStackTrace();
//                }
//
//            } else if ( cmd.startsWith( "cd " )) {
//                try {
//                    pwd = pwd.resolve( cmd.substring( 3 ) ).toRealPath().toAbsolutePath();
//                    System.out.println(pwd);
//                } catch( IOException e ) {
//                    e.printStackTrace();
//                }
//
//            } else {
//                System.out.println("toti commands: exit, log, pwd, cd <path>, ls");
//            }
//
//
//        }
    }


    private static NioDavServer getAndStartServer( Path root ) {
        int port = 12000;
        while( !available( port ) ) {
            port++;
        }

        NioDavServer server = new NioDavServer( root, port ).start();

        Runtime.getRuntime().addShutdownHook( new Thread( server::stop ) );

        return server;
    }

    private static Path getStellvertreterRoot( Path host, Conf conf ) {
        if( conf.elsewhere != null ) {
            return stellvertreter().
                    host( host ).
                    password( conf.passwd.toCharArray() ).
                    spaceControl( conf.spaceLimit ).
                    elsewhere( new FSElsewhere( conf.elsewhere ) ).
                    build().
                    getPath( "/play" );

        }

        return stellvertreter().
                host( host ).
                password( conf.passwd.toCharArray() ).
                spaceControl( conf.spaceLimit ).
                build().
                getPath( "/play" );
    }

//    private static Path openStell( Path host ) {
//
//        String passwd;
//        while( true ) {
//            passwd = c.readLine( "Passwd: " );
//
//            if ( !Files.exists( host.resolve( ".svsanity" ) )) {
//                System.out.printf( "not possible to validate passwd lets hope its correct" );
//                break;
//            }
//
//            if ( new PasswordHash().same( Filess.readAllBytes( host.resolve( ".svsanity" ) ), passwd.toCharArray())) {
//                break;
//            }
//
//            System.out.println("wrong password");
//        }
//
//        int port = 12000;
//        while( !available( port ) ) {
//            port++;
//        }
//
//        System.out.println( "using port:" + port );
//
//        String volumeName = "";
//        if ( Files.exists( host.resolve( ".svvolume" ) )) {
//            volumeName = newString( Filess.readAllBytes( host.resolve( ".svvolume" ) ) );
//        } else {
//            volumeName = host.getFileName().toString();
//        }
//
//        String vn = c.readLine( "volume name ["  + volumeName + "]: ");
//        if ( vn.length() > 0 ) {
//            volumeName = vn;
//        }
//
//        //sc
//        String sc = c.readLine( "space control ["  + "10G" + "]: ");
//        long space = 10000000000l;
//        if ( sc.length() > 0 ) {
//            space = Long.valueOf( sc );
//        }
//
//
//
//        stellfs = stellvertreter().
//                host( host ).
//                password( passwd.toCharArray() ).
//                spaceControl( space ).
//                build().
//                getPath( "/play" );
//
//        return stellfs;
//
////        server = new NioDavServer( stellfs, port ).start();
////
////        System.out.println( "mkdir /Volumes/" + volumeName );
////        System.out.println( "mount_webdav -i -v " + volumeName + " http://localhost:" + port + " /Volumes/" + volumeName );
//    }

//    private static void newStell( Path host ) {
//
//        if( c == null ) {
//            System.err.println( "No console." );
//            System.exit( 1 );
//        }
//
//        String passwd = "";
//        while( true ) {
//            passwd = c.readLine( "Passwd: " );
//
//            if( passwd.length() < 10 ) {
//                System.out.println( "password too short (<10)" );
//            } else {
//                String passwd2 = c.readLine( "repeat: " );
//                if ( passwd.equals( passwd2 )) {
//                    break;
//                }
//                System.out.println("passwords not equal: try again");
//            }
//        }
//
//        Path els = null;
//        while( true ) {
//            String el = c.readLine( "Elsewhere: " );
//            System.out.println(el);
//            els = Paths.get( el );
//            System.out.println(els);
//
//            if( el.length() > 0 && Files.exists( els ) && Files.isDirectory( els ) && isEmpty( els ) ) {
//                break;
//            }
//
//            System.out.println( "else must be existing empty dir" );
//        }
//
//        int port = 12000;
//        while( !available( port ) ) {
//            port++;
//        }
//
//        System.out.println( "using port:" + port );
//
//
//        String volumeName = "";
//        if ( Files.exists( host.resolve( ".svvolume" ) )) {
//            volumeName = newString( Filess.readAllBytes( host.resolve( ".svvolume" ) ) );
//        } else {
//            volumeName = host.getFileName().toString();
//        }
//
//        String vn = c.readLine( "volume name ["  + volumeName + "]: ");
//        if ( vn.length() > 0 ) {
//            volumeName = vn;
//        }
//
//        stellfs = stellvertreter().
//                host( host ).
//                elsewhere( new FSElsewhere( els ) ).
//                //clear( memoryFS().name( "clear" ).build().getPath( "/cc" ) ).
//                        password( passwd.toCharArray() ).
//                build().
//                getPath( "/play" );
//
//        server = new NioDavServer( stellfs, port ).start();
//
//        System.out.println( "mkdir /Volumes/" + volumeName );
//        System.out.println( "mount_webdav -i -v " + volumeName + " http://localhost:" + port + " /Volumes/" + volumeName );
//
//    }

    public static Path getCurrentDir() {
        return Paths.get( System.getProperty( "user.dir" ) );
    }

    private static boolean available( int port ) {
        try( Socket ignored = new Socket( "localhost", port ) ) {
            return false;
        } catch( IOException ignored ) {
            return true;
        }
    }

    static public class TotiLogger extends Log.Logger {

        private final Path file;
        private boolean toSTD = true;
        private boolean toFile = true;

        public TotiLogger( Path file ) {
            this.file = file;
        }

        public void showLog( boolean on ) {
            this.toSTD = on;
        }

        @Override
        protected void print( String message ) {
            if( toSTD ) {
                super.print( message );
            }

            Filess.write( file, getBytes( message + "\n" ), APPEND, WRITE, CREATE );
        }

        public boolean toggle() {
            toSTD = !toSTD;
            return toSTD;
        }

        public void onOff( boolean on ) {
            toSTD = on;
        }
    }

    public static <B, C, D> D with( Supplier<P<B, C>> fct, BiFunction<B, C, D> bound ) {
        P<B, C> ret = fct.get();
        B b = ret.i0;
        C c = ret.i1;

        return bound.apply( ret.i0, ret.i1 );
    }

    private static void mount( Conf conf, int port ) {

        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec( new String[]{
                    "mount_webdav",
                    "-v", conf.volume,
                    "http://localhost:" + port,
                    "/Volumes/" + conf.volume } );
////        System.out.println( "mount_webdav -i -v " + volumeName + " http://localhost:" + port + " /Volumes/" + volumeName );
//            if( proc.waitFor() == 0 ) {
//                InputStream in = proc.getInputStream();
//                int available = in.available();
//                byte[] outputBytes = new byte[ available ];
//
//                in.read( outputBytes );
//                String pid = new String( outputBytes );
//
//                System.out.println( "Your pid is " + pid );
//            }
        } catch( IOException e ) {
            e.printStackTrace();
        }

    }

    private static void umount( Conf conf ) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec( new String[]{
                    "umount",
                    "/Volumes/" + conf.volume } );
        } catch( IOException e ) {
            e.printStackTrace();
        }

    }
}
