package de.pfabulist.lindwurm.toti;

import org.json.JSONObject;

import java.nio.file.Path;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

public class Conf {
    public String passwd; // transient
    public Path elsewhere; // transient, saved otherwise
    public boolean logToFile;
    public boolean logToConsole;
    public long spaceLimit;
    public String volume;


    public Conf() {
        logToFile = false;
        logToConsole = true;
        spaceLimit = -1;//10000000000l;
    }

    public static Conf valueOf( JSONObject obj ) {
        Conf conf = new Conf();

        conf.logToConsole = obj.getBoolean( "logToConsole" );
        conf.logToFile  = obj.getBoolean( "logToFile" );
        conf.spaceLimit = obj.getLong( "spaceLimit" );
        conf.volume = obj.getString( "volume" );

        return conf;
    }

    @Override
    public String toString() {

        JSONObject jobj = new JSONObject();
        jobj.put( "volume", volume );
        jobj.put( "logToConsole", logToConsole );
        jobj.put( "logToFile", logToFile );
        jobj.put( "spaceLimit", spaceLimit );


        return jobj.toString();
    }
}
