/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests.descriptionbuilders;

import de.pfabulist.kleinod.nio.PathIKWID;
import de.pfabulist.lindwurm.niotest.tests.FSDescription;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.DescriptionBuilder;
import de.pfabulist.lindwurm.niotest.tests.descriptionbuilders.ReadonlyPlayground;
import de.pfabulist.lindwurm.niotest.tests.topics.Closable;
import de.pfabulist.lindwurm.niotest.tests.topics.NotDefaultFileSystem;
import de.pfabulist.lindwurm.niotest.tests.topics.Readonly;
import de.pfabulist.lindwurm.niotest.tests.topics.SameFSDifferentStore;
import de.pfabulist.lindwurm.niotest.tests.topics.SecondFileSystem;
import de.pfabulist.lindwurm.niotest.tests.topics.SizeLimit;
import de.pfabulist.lindwurm.niotest.tests.topics.WorkingDirectoryInPlaygroundTree;
import java.nio.file.FileSystems;
import java.nio.file.Path;

public class Playgrounds<T>
extends DescriptionBuilder<T> {
    public Playgrounds(FSDescription descr, T t) {
        super(descr, t);
    }

    public Playgrounds<T> std(Path root) {
        this.descr.removeTopic(Readonly.class);
        this.descr.props.put("playground", root);
        if (!root.isAbsolute()) {
            throw new IllegalArgumentException("root path must be nonnull and absolute " + root);
        }
        if (!PathIKWID.absoluteGetRoot((Path)root).equals(PathIKWID.absoluteGetRoot((Path)root.getFileSystem().getPath("", new String[0]).toAbsolutePath()))) {
            this.descr.removeTopic(WorkingDirectoryInPlaygroundTree.class);
        }
        if (root.getFileSystem().equals(FileSystems.getDefault())) {
            this.descr.removeTopic(NotDefaultFileSystem.class);
        }
        return this;
    }

    public ReadonlyPlayground<Playgrounds<T>> readonly(Path root) {
        return new ReadonlyPlayground<Playgrounds<T>>(this.descr, this);
    }

    public Playgrounds<T> closable(Path root) {
        this.descr.closedFSVars = new FSDescription.ClosedFSVars(root);
        return this;
    }

    public Playgrounds<T> noClosable() {
        this.descr.removeTopic(Closable.class);
        return this;
    }

    public Playgrounds<T> differentProvider(Path root) {
        this.descr.props.put("otherProviderPlayground", root);
        return this;
    }

    public Playgrounds<T> sameProviderDifferentFileSystem(Path root) {
        this.descr.props.put("playground2", root);
        if (!root.isAbsolute()) {
            throw new IllegalArgumentException("root path must be nonull and absolute " + root);
        }
        return this;
    }

    public Playgrounds<T> noSameProviderDifferentFileSystem() {
        this.descr.removeTopic(SecondFileSystem.class);
        return this;
    }

    public Playgrounds<T> sizeLimitedPlayground(Path limited) {
        this.descr.props.put("sizeLimitedPlayground", limited);
        return this;
    }

    public Playgrounds<T> noSizeLimit() {
        this.descr.removeTopic(SizeLimit.class);
        return this;
    }

    public Playgrounds<T> sameFileSystemDifferentStore(Path path) {
        this.descr.props.put("differentStore", path);
        return this;
    }

    public Playgrounds<T> noSameFileSystemDifferentStore() {
        this.descr.removeTopic(SameFSDifferentStore.class);
        return this;
    }

    @Override
    public T next() {
        return (T)this.t;
    }
}

